package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDayu invokes the dm.CreateDayu API synchronously
// api document: https://help.aliyun.com/api/dm/createdayu.html
func (client *Client) CreateDayu(request *CreateDayuRequest) (response *CreateDayuResponse, err error) {
	response = CreateCreateDayuResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDayuWithChan invokes the dm.CreateDayu API asynchronously
// api document: https://help.aliyun.com/api/dm/createdayu.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDayuWithChan(request *CreateDayuRequest) (<-chan *CreateDayuResponse, <-chan error) {
	responseChan := make(chan *CreateDayuResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDayu(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDayuWithCallback invokes the dm.CreateDayu API asynchronously
// api document: https://help.aliyun.com/api/dm/createdayu.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateDayuWithCallback(request *CreateDayuRequest, callback func(response *CreateDayuResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDayuResponse
		var err error
		defer close(result)
		response, err = client.CreateDayu(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDayuRequest is the request struct for api CreateDayu
type CreateDayuRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	AccountType          requests.Integer `position:"Query" name:"AccountType"`
}

// CreateDayuResponse is the response struct for api CreateDayu
type CreateDayuResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDayuRequest creates a request to invoke CreateDayu API
func CreateCreateDayuRequest() (request *CreateDayuRequest) {
	request = &CreateDayuRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "CreateDayu", "", "")
	return
}

// CreateCreateDayuResponse creates a response to parse from CreateDayu response
func CreateCreateDayuResponse() (response *CreateDayuResponse) {
	response = &CreateDayuResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
