package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryDatabase invokes the dms_dg.RetryDatabase API synchronously
func (client *Client) RetryDatabase(request *RetryDatabaseRequest) (response *RetryDatabaseResponse, err error) {
	response = CreateRetryDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// RetryDatabaseWithChan invokes the dms_dg.RetryDatabase API asynchronously
func (client *Client) RetryDatabaseWithChan(request *RetryDatabaseRequest) (<-chan *RetryDatabaseResponse, <-chan error) {
	responseChan := make(chan *RetryDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryDatabaseWithCallback invokes the dms_dg.RetryDatabase API asynchronously
func (client *Client) RetryDatabaseWithCallback(request *RetryDatabaseRequest, callback func(response *RetryDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryDatabaseResponse
		var err error
		defer close(result)
		response, err = client.RetryDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryDatabaseRequest is the request struct for api RetryDatabase
type RetryDatabaseRequest struct {
	*requests.RpcRequest
	ClientToken   string           `position:"Body" name:"ClientToken"`
	Host          string           `position:"Body" name:"Host"`
	DbUserName    string           `position:"Body" name:"DbUserName"`
	DbDescription string           `position:"Body" name:"DbDescription"`
	GatewayId     string           `position:"Body" name:"GatewayId"`
	DbName        string           `position:"Body" name:"DbName"`
	Port          requests.Integer `position:"Body" name:"Port"`
	DbPassword    string           `position:"Body" name:"DbPassword"`
	DbType        string           `position:"Body" name:"DbType"`
}

// RetryDatabaseResponse is the response struct for api RetryDatabase
type RetryDatabaseResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRetryDatabaseRequest creates a request to invoke RetryDatabase API
func CreateRetryDatabaseRequest() (request *RetryDatabaseRequest) {
	request = &RetryDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "RetryDatabase", "", "")
	request.Method = requests.POST
	return
}

// CreateRetryDatabaseResponse creates a response to parse from RetryDatabase response
func CreateRetryDatabaseResponse() (response *RetryDatabaseResponse) {
	response = &RetryDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
