package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableUser invokes the dms_enterprise.EnableUser API synchronously
func (client *Client) EnableUser(request *EnableUserRequest) (response *EnableUserResponse, err error) {
	response = CreateEnableUserResponse()
	err = client.DoAction(request, response)
	return
}

// EnableUserWithChan invokes the dms_enterprise.EnableUser API asynchronously
func (client *Client) EnableUserWithChan(request *EnableUserRequest) (<-chan *EnableUserResponse, <-chan error) {
	responseChan := make(chan *EnableUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableUserWithCallback invokes the dms_enterprise.EnableUser API asynchronously
func (client *Client) EnableUserWithCallback(request *EnableUserRequest, callback func(response *EnableUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableUserResponse
		var err error
		defer close(result)
		response, err = client.EnableUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableUserRequest is the request struct for api EnableUser
type EnableUserRequest struct {
	*requests.RpcRequest
	Tid requests.Integer `position:"Query" name:"Tid"`
	Uid string           `position:"Query" name:"Uid"`
}

// EnableUserResponse is the response struct for api EnableUser
type EnableUserResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateEnableUserRequest creates a request to invoke EnableUser API
func CreateEnableUserRequest() (request *EnableUserRequest) {
	request = &EnableUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "EnableUser", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableUserResponse creates a response to parse from EnableUser response
func CreateEnableUserResponse() (response *EnableUserResponse) {
	response = &EnableUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
