package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCardSmsDetails invokes the dysmsapi.GetCardSmsDetails API synchronously
func (client *Client) GetCardSmsDetails(request *GetCardSmsDetailsRequest) (response *GetCardSmsDetailsResponse, err error) {
	response = CreateGetCardSmsDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// GetCardSmsDetailsWithChan invokes the dysmsapi.GetCardSmsDetails API asynchronously
func (client *Client) GetCardSmsDetailsWithChan(request *GetCardSmsDetailsRequest) (<-chan *GetCardSmsDetailsResponse, <-chan error) {
	responseChan := make(chan *GetCardSmsDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCardSmsDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCardSmsDetailsWithCallback invokes the dysmsapi.GetCardSmsDetails API asynchronously
func (client *Client) GetCardSmsDetailsWithCallback(request *GetCardSmsDetailsRequest, callback func(response *GetCardSmsDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCardSmsDetailsResponse
		var err error
		defer close(result)
		response, err = client.GetCardSmsDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCardSmsDetailsRequest is the request struct for api GetCardSmsDetails
type GetCardSmsDetailsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	LowcodeTenantId      string           `position:"Query" name:"LowcodeTenantId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	LowcodePhysicAppName string           `position:"Query" name:"LowcodePhysicAppName"`
	SendDate             string           `position:"Query" name:"SendDate"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	BizSmsId             string           `position:"Query" name:"BizSmsId"`
	RouteName            string           `position:"Query" name:"RouteName"`
	BizDigitId           string           `position:"Query" name:"BizDigitId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	CurrentPage          requests.Integer `position:"Query" name:"CurrentPage"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	LowcodeLogicAppName  string           `position:"Query" name:"LowcodeLogicAppName"`
	BizCardId            string           `position:"Query" name:"BizCardId"`
}

// GetCardSmsDetailsResponse is the response struct for api GetCardSmsDetails
type GetCardSmsDetailsResponse struct {
	*responses.BaseResponse
	AccessDeniedDetail string            `json:"AccessDeniedDetail" xml:"AccessDeniedDetail"`
	Message            string            `json:"Message" xml:"Message"`
	Code               string            `json:"Code" xml:"Code"`
	Success            bool              `json:"Success" xml:"Success"`
	CardSendDetailDTO  CardSendDetailDTO `json:"CardSendDetailDTO" xml:"CardSendDetailDTO"`
}

// CreateGetCardSmsDetailsRequest creates a request to invoke GetCardSmsDetails API
func CreateGetCardSmsDetailsRequest() (request *GetCardSmsDetailsRequest) {
	request = &GetCardSmsDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "GetCardSmsDetails", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCardSmsDetailsResponse creates a response to parse from GetCardSmsDetails response
func CreateGetCardSmsDetailsResponse() (response *GetCardSmsDetailsResponse) {
	response = &GetCardSmsDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
