package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDesktops invokes the ecd.CreateDesktops API synchronously
func (client *Client) CreateDesktops(request *CreateDesktopsRequest) (response *CreateDesktopsResponse, err error) {
	response = CreateCreateDesktopsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDesktopsWithChan invokes the ecd.CreateDesktops API asynchronously
func (client *Client) CreateDesktopsWithChan(request *CreateDesktopsRequest) (<-chan *CreateDesktopsResponse, <-chan error) {
	responseChan := make(chan *CreateDesktopsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDesktops(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDesktopsWithCallback invokes the ecd.CreateDesktops API asynchronously
func (client *Client) CreateDesktopsWithCallback(request *CreateDesktopsRequest, callback func(response *CreateDesktopsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDesktopsResponse
		var err error
		defer close(result)
		response, err = client.CreateDesktops(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDesktopsRequest is the request struct for api CreateDesktops
type CreateDesktopsRequest struct {
	*requests.RpcRequest
	ResourceGroupId         string                             `position:"Query" name:"ResourceGroupId"`
	Hostname                string                             `position:"Query" name:"Hostname"`
	DesktopTimers           *[]CreateDesktopsDesktopTimers     `position:"Query" name:"DesktopTimers"  type:"Repeated"`
	DesktopNameSuffix       requests.Boolean                   `position:"Query" name:"DesktopNameSuffix"`
	SystemDiskSize          string                             `position:"Query" name:"SystemDiskSize"`
	EndUserId               *[]string                          `position:"Query" name:"EndUserId"  type:"Repeated"`
	Tag                     *[]CreateDesktopsTag               `position:"Query" name:"Tag"  type:"Repeated"`
	BundleModels            *[]CreateDesktopsBundleModels      `position:"Query" name:"BundleModels"  type:"Repeated"`
	VolumeEncryptionEnabled requests.Boolean                   `position:"Query" name:"VolumeEncryptionEnabled"`
	MonthDesktopSetting     CreateDesktopsMonthDesktopSetting  `position:"Query" name:"MonthDesktopSetting"  type:"Struct"`
	Period                  requests.Integer                   `position:"Query" name:"Period"`
	CommonDesktopSetting    CreateDesktopsCommonDesktopSetting `position:"Query" name:"CommonDesktopSetting"  type:"Struct"`
	UserCommands            *[]CreateDesktopsUserCommands      `position:"Query" name:"UserCommands"  type:"Repeated"`
	GroupId                 string                             `position:"Query" name:"GroupId"`
	EcsInstanceType         string                             `position:"Query" name:"EcsInstanceType"`
	PeriodUnit              string                             `position:"Query" name:"PeriodUnit"`
	AutoRenew               requests.Boolean                   `position:"Query" name:"AutoRenew"`
	DataDiskSize            string                             `position:"Query" name:"DataDiskSize"`
	PolicyGroupId           string                             `position:"Query" name:"PolicyGroupId"`
	VolumeEncryptionKey     string                             `position:"Query" name:"VolumeEncryptionKey"`
	OfficeSiteId            string                             `position:"Query" name:"OfficeSiteId"`
	SnapshotPolicyId        string                             `position:"Query" name:"SnapshotPolicyId"`
	ImageId                 string                             `position:"Query" name:"ImageId"`
	BundleId                string                             `position:"Query" name:"BundleId"`
	EnableInternetAccess    requests.Boolean                   `position:"Query" name:"EnableInternetAccess"`
	UserAssignMode          string                             `position:"Query" name:"UserAssignMode"`
	DirectoryId             string                             `position:"Query" name:"DirectoryId"`
	DesktopMemberIp         string                             `position:"Query" name:"DesktopMemberIp"`
	SubnetId                string                             `position:"Query" name:"SubnetId"`
	DesktopName             string                             `position:"Query" name:"DesktopName"`
	Amount                  requests.Integer                   `position:"Query" name:"Amount"`
	AutoPay                 requests.Boolean                   `position:"Query" name:"AutoPay"`
	PromotionId             string                             `position:"Query" name:"PromotionId"`
	VpcId                   string                             `position:"Query" name:"VpcId"`
	ChargeType              string                             `position:"Query" name:"ChargeType"`
	UserName                string                             `position:"Query" name:"UserName"`
}

// CreateDesktopsDesktopTimers is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsDesktopTimers struct {
	CronExpression     string `name:"CronExpression"`
	TimerType          string `name:"TimerType"`
	AllowClientSetting string `name:"AllowClientSetting"`
	ResetType          string `name:"ResetType"`
	Enforce            string `name:"Enforce"`
	Interval           string `name:"Interval"`
	OperationType      string `name:"OperationType"`
}

// CreateDesktopsTag is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateDesktopsBundleModels is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsBundleModels struct {
	VolumeEncryptionEnabled string    `name:"VolumeEncryptionEnabled"`
	VolumeEncryptionKey     string    `name:"VolumeEncryptionKey"`
	Amount                  string    `name:"Amount"`
	DesktopName             string    `name:"DesktopName"`
	Hostname                string    `name:"Hostname"`
	EndUserIds              *[]string `name:"EndUserIds" type:"Repeated"`
	BundleId                string    `name:"BundleId"`
}

// CreateDesktopsMonthDesktopSetting is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsMonthDesktopSetting struct {
	PostPaidAfterUsedUp string `name:"PostPaidAfterUsedUp"`
	DesktopId           string `name:"DesktopId"`
	UseDuration         string `name:"UseDuration"`
	BuyerId             string `name:"BuyerId"`
}

// CreateDesktopsCommonDesktopSetting is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsCommonDesktopSetting struct {
	DesktopClassify string `name:"DesktopClassify"`
	UsingPool       string `name:"UsingPool"`
	DelayProduct    string `name:"DelayProduct"`
	DesktopId       string `name:"DesktopId"`
	UseDuration     string `name:"UseDuration"`
}

// CreateDesktopsUserCommands is a repeated param struct in CreateDesktopsRequest
type CreateDesktopsUserCommands struct {
	ContentEncoding string `name:"ContentEncoding"`
	Content         string `name:"Content"`
	ContentType     string `name:"ContentType"`
}

// CreateDesktopsResponse is the response struct for api CreateDesktops
type CreateDesktopsResponse struct {
	*responses.BaseResponse
	OrderId   string   `json:"OrderId" xml:"OrderId"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	DesktopId []string `json:"DesktopId" xml:"DesktopId"`
}

// CreateCreateDesktopsRequest creates a request to invoke CreateDesktops API
func CreateCreateDesktopsRequest() (request *CreateDesktopsRequest) {
	request = &CreateDesktopsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateDesktops", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDesktopsResponse creates a response to parse from CreateDesktops response
func CreateCreateDesktopsResponse() (response *CreateDesktopsResponse) {
	response = &CreateDesktopsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
