package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopOversoldUser invokes the ecd.DescribeDesktopOversoldUser API synchronously
func (client *Client) DescribeDesktopOversoldUser(request *DescribeDesktopOversoldUserRequest) (response *DescribeDesktopOversoldUserResponse, err error) {
	response = CreateDescribeDesktopOversoldUserResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopOversoldUserWithChan invokes the ecd.DescribeDesktopOversoldUser API asynchronously
func (client *Client) DescribeDesktopOversoldUserWithChan(request *DescribeDesktopOversoldUserRequest) (<-chan *DescribeDesktopOversoldUserResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopOversoldUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopOversoldUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopOversoldUserWithCallback invokes the ecd.DescribeDesktopOversoldUser API asynchronously
func (client *Client) DescribeDesktopOversoldUserWithCallback(request *DescribeDesktopOversoldUserRequest, callback func(response *DescribeDesktopOversoldUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopOversoldUserResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopOversoldUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopOversoldUserRequest is the request struct for api DescribeDesktopOversoldUser
type DescribeDesktopOversoldUserRequest struct {
	*requests.RpcRequest
	OversoldGroupId string           `position:"Query" name:"OversoldGroupId"`
	ClientToken     string           `position:"Query" name:"ClientToken"`
	UserGroupId     string           `position:"Query" name:"UserGroupId"`
	NextToken       string           `position:"Query" name:"NextToken"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
	EndUserId       string           `position:"Query" name:"EndUserId"`
	UserDesktopIds  *[]string        `position:"Query" name:"UserDesktopIds"  type:"Repeated"`
}

// DescribeDesktopOversoldUserResponse is the response struct for api DescribeDesktopOversoldUser
type DescribeDesktopOversoldUserResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Count     int        `json:"Count" xml:"Count"`
	NextToken string     `json:"NextToken" xml:"NextToken"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeDesktopOversoldUserRequest creates a request to invoke DescribeDesktopOversoldUser API
func CreateDescribeDesktopOversoldUserRequest() (request *DescribeDesktopOversoldUserRequest) {
	request = &DescribeDesktopOversoldUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopOversoldUser", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopOversoldUserResponse creates a response to parse from DescribeDesktopOversoldUser response
func CreateDescribeDesktopOversoldUserResponse() (response *DescribeDesktopOversoldUserResponse) {
	response = &DescribeDesktopOversoldUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
