package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNetworkInterface invokes the eflo.GetNetworkInterface API synchronously
func (client *Client) GetNetworkInterface(request *GetNetworkInterfaceRequest) (response *GetNetworkInterfaceResponse, err error) {
	response = CreateGetNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// GetNetworkInterfaceWithChan invokes the eflo.GetNetworkInterface API asynchronously
func (client *Client) GetNetworkInterfaceWithChan(request *GetNetworkInterfaceRequest) (<-chan *GetNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *GetNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNetworkInterfaceWithCallback invokes the eflo.GetNetworkInterface API asynchronously
func (client *Client) GetNetworkInterfaceWithCallback(request *GetNetworkInterfaceRequest, callback func(response *GetNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.GetNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNetworkInterfaceRequest is the request struct for api GetNetworkInterface
type GetNetworkInterfaceRequest struct {
	*requests.RpcRequest
	SubnetId           string `position:"Body" name:"SubnetId"`
	NetworkInterfaceId string `position:"Body" name:"NetworkInterfaceId"`
}

// GetNetworkInterfaceResponse is the response struct for api GetNetworkInterface
type GetNetworkInterfaceResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetNetworkInterfaceRequest creates a request to invoke GetNetworkInterface API
func CreateGetNetworkInterfaceRequest() (request *GetNetworkInterfaceRequest) {
	request = &GetNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetNetworkInterface", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNetworkInterfaceResponse creates a response to parse from GetNetworkInterface response
func CreateGetNetworkInterfaceResponse() (response *GetNetworkInterfaceResponse) {
	response = &GetNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
