package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePatternTypes invokes the ess.DescribePatternTypes API synchronously
func (client *Client) DescribePatternTypes(request *DescribePatternTypesRequest) (response *DescribePatternTypesResponse, err error) {
	response = CreateDescribePatternTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePatternTypesWithChan invokes the ess.DescribePatternTypes API asynchronously
func (client *Client) DescribePatternTypesWithChan(request *DescribePatternTypesRequest) (<-chan *DescribePatternTypesResponse, <-chan error) {
	responseChan := make(chan *DescribePatternTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePatternTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePatternTypesWithCallback invokes the ess.DescribePatternTypes API asynchronously
func (client *Client) DescribePatternTypesWithCallback(request *DescribePatternTypesRequest, callback func(response *DescribePatternTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePatternTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribePatternTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePatternTypesRequest is the request struct for api DescribePatternTypes
type DescribePatternTypesRequest struct {
	*requests.RpcRequest
	MaximumCpuCoreCount                requests.Integer `position:"Query" name:"MaximumCpuCoreCount"`
	MaximumGpuAmount                   requests.Integer `position:"Query" name:"MaximumGpuAmount"`
	MaximumMemorySize                  requests.Float   `position:"Query" name:"MaximumMemorySize"`
	MinimumCpuCoreCount                requests.Integer `position:"Query" name:"MinimumCpuCoreCount"`
	Cores                              requests.Integer `position:"Query" name:"Cores"`
	InstanceTypeFamilies               *[]string        `position:"Query" name:"InstanceTypeFamilies"  type:"Repeated"`
	MinimumBaselineCredit              requests.Integer `position:"Query" name:"MinimumBaselineCredit"`
	CpuArchitectures                   *[]string        `position:"Query" name:"CpuArchitectures"  type:"Repeated"`
	InstanceCategories                 *[]string        `position:"Query" name:"InstanceCategories"  type:"Repeated"`
	MaxPrice                           requests.Float   `position:"Query" name:"MaxPrice"`
	MinimumGpuAmount                   requests.Integer `position:"Query" name:"MinimumGpuAmount"`
	BurstablePerformance               string           `position:"Query" name:"BurstablePerformance"`
	PhysicalProcessorModels            *[]string        `position:"Query" name:"PhysicalProcessorModels"  type:"Repeated"`
	SpotStrategy                       string           `position:"Query" name:"SpotStrategy"`
	VSwitchId                          *[]string        `position:"Query" name:"VSwitchId"  type:"Repeated"`
	MinimumEniQuantity                 requests.Integer `position:"Query" name:"MinimumEniQuantity"`
	MinimumMemorySize                  requests.Float   `position:"Query" name:"MinimumMemorySize"`
	InstanceFamilyLevel                string           `position:"Query" name:"InstanceFamilyLevel"`
	ZoneId                             *[]string        `position:"Query" name:"ZoneId"  type:"Repeated"`
	MemoryList                         *[]string        `position:"Query" name:"MemoryList"  type:"Repeated"`
	Memory                             requests.Float   `position:"Query" name:"Memory"`
	MinimumEniIpv6AddressQuantity      requests.Integer `position:"Query" name:"MinimumEniIpv6AddressQuantity"`
	CoresList                          *[]string        `position:"Query" name:"CoresList"  type:"Repeated"`
	Architecture                       *[]string        `position:"Query" name:"Architecture"  type:"Repeated"`
	MinimumInitialCredit               requests.Integer `position:"Query" name:"MinimumInitialCredit"`
	ExcludedInstanceType               *[]string        `position:"Query" name:"ExcludedInstanceType"  type:"Repeated"`
	MinimumEniPrivateIpAddressQuantity requests.Integer `position:"Query" name:"MinimumEniPrivateIpAddressQuantity"`
	GpuSpecs                           *[]string        `position:"Query" name:"GpuSpecs"  type:"Repeated"`
	ChannelId                          requests.Integer `position:"Query" name:"ChannelId"`
}

// DescribePatternTypesResponse is the response struct for api DescribePatternTypes
type DescribePatternTypesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	PatternTypes []PatternType `json:"PatternTypes" xml:"PatternTypes"`
}

// CreateDescribePatternTypesRequest creates a request to invoke DescribePatternTypes API
func CreateDescribePatternTypesRequest() (request *DescribePatternTypesRequest) {
	request = &DescribePatternTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DescribePatternTypes", "ess", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribePatternTypesResponse creates a response to parse from DescribePatternTypes response
func CreateDescribePatternTypesResponse() (response *DescribePatternTypesResponse) {
	response = &DescribePatternTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
