package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteHBaseSlbServer invokes the hbase.DeleteHBaseSlbServer API synchronously
func (client *Client) DeleteHBaseSlbServer(request *DeleteHBaseSlbServerRequest) (response *DeleteHBaseSlbServerResponse, err error) {
	response = CreateDeleteHBaseSlbServerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteHBaseSlbServerWithChan invokes the hbase.DeleteHBaseSlbServer API asynchronously
func (client *Client) DeleteHBaseSlbServerWithChan(request *DeleteHBaseSlbServerRequest) (<-chan *DeleteHBaseSlbServerResponse, <-chan error) {
	responseChan := make(chan *DeleteHBaseSlbServerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteHBaseSlbServer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteHBaseSlbServerWithCallback invokes the hbase.DeleteHBaseSlbServer API asynchronously
func (client *Client) DeleteHBaseSlbServerWithCallback(request *DeleteHBaseSlbServerRequest, callback func(response *DeleteHBaseSlbServerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteHBaseSlbServerResponse
		var err error
		defer close(result)
		response, err = client.DeleteHBaseSlbServer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteHBaseSlbServerRequest is the request struct for api DeleteHBaseSlbServer
type DeleteHBaseSlbServerRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
	SlbServer string `position:"Query" name:"SlbServer"`
}

// DeleteHBaseSlbServerResponse is the response struct for api DeleteHBaseSlbServer
type DeleteHBaseSlbServerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteHBaseSlbServerRequest creates a request to invoke DeleteHBaseSlbServer API
func CreateDeleteHBaseSlbServerRequest() (request *DeleteHBaseSlbServerRequest) {
	request = &DeleteHBaseSlbServerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DeleteHBaseSlbServer", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteHBaseSlbServerResponse creates a response to parse from DeleteHBaseSlbServer response
func CreateDeleteHBaseSlbServerResponse() (response *DeleteHBaseSlbServerResponse) {
	response = &DeleteHBaseSlbServerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
