package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAuthenticatorAttribute invokes the idaas_doraemon.UpdateAuthenticatorAttribute API synchronously
func (client *Client) UpdateAuthenticatorAttribute(request *UpdateAuthenticatorAttributeRequest) (response *UpdateAuthenticatorAttributeResponse, err error) {
	response = CreateUpdateAuthenticatorAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAuthenticatorAttributeWithChan invokes the idaas_doraemon.UpdateAuthenticatorAttribute API asynchronously
func (client *Client) UpdateAuthenticatorAttributeWithChan(request *UpdateAuthenticatorAttributeRequest) (<-chan *UpdateAuthenticatorAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateAuthenticatorAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAuthenticatorAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAuthenticatorAttributeWithCallback invokes the idaas_doraemon.UpdateAuthenticatorAttribute API asynchronously
func (client *Client) UpdateAuthenticatorAttributeWithCallback(request *UpdateAuthenticatorAttributeRequest, callback func(response *UpdateAuthenticatorAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAuthenticatorAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateAuthenticatorAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAuthenticatorAttributeRequest is the request struct for api UpdateAuthenticatorAttribute
type UpdateAuthenticatorAttributeRequest struct {
	*requests.RpcRequest
	UserId                string `position:"Query" name:"UserId"`
	AuthenticatorName     string `position:"Query" name:"AuthenticatorName"`
	AuthenticatorUuid     string `position:"Query" name:"AuthenticatorUuid"`
	ApplicationExternalId string `position:"Query" name:"ApplicationExternalId"`
}

// UpdateAuthenticatorAttributeResponse is the response struct for api UpdateAuthenticatorAttribute
type UpdateAuthenticatorAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAuthenticatorAttributeRequest creates a request to invoke UpdateAuthenticatorAttribute API
func CreateUpdateAuthenticatorAttributeRequest() (request *UpdateAuthenticatorAttributeRequest) {
	request = &UpdateAuthenticatorAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "UpdateAuthenticatorAttribute", "idaasauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAuthenticatorAttributeResponse creates a response to parse from UpdateAuthenticatorAttribute response
func CreateUpdateAuthenticatorAttributeResponse() (response *UpdateAuthenticatorAttributeResponse) {
	response = &UpdateAuthenticatorAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
