package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateSuperResolutionImage invokes the imageenhan.GenerateSuperResolutionImage API synchronously
func (client *Client) GenerateSuperResolutionImage(request *GenerateSuperResolutionImageRequest) (response *GenerateSuperResolutionImageResponse, err error) {
	response = CreateGenerateSuperResolutionImageResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateSuperResolutionImageWithChan invokes the imageenhan.GenerateSuperResolutionImage API asynchronously
func (client *Client) GenerateSuperResolutionImageWithChan(request *GenerateSuperResolutionImageRequest) (<-chan *GenerateSuperResolutionImageResponse, <-chan error) {
	responseChan := make(chan *GenerateSuperResolutionImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateSuperResolutionImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateSuperResolutionImageWithCallback invokes the imageenhan.GenerateSuperResolutionImage API asynchronously
func (client *Client) GenerateSuperResolutionImageWithCallback(request *GenerateSuperResolutionImageRequest, callback func(response *GenerateSuperResolutionImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateSuperResolutionImageResponse
		var err error
		defer close(result)
		response, err = client.GenerateSuperResolutionImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateSuperResolutionImageRequest is the request struct for api GenerateSuperResolutionImage
type GenerateSuperResolutionImageRequest struct {
	*requests.RpcRequest
	Scale         requests.Integer `position:"Body" name:"Scale"`
	UserData      string           `position:"Body" name:"UserData"`
	OutputFormat  string           `position:"Body" name:"OutputFormat"`
	Async         requests.Boolean `position:"Body" name:"Async"`
	ImageUrl      string           `position:"Body" name:"ImageUrl"`
	OutputQuality requests.Integer `position:"Body" name:"OutputQuality"`
}

// GenerateSuperResolutionImageResponse is the response struct for api GenerateSuperResolutionImage
type GenerateSuperResolutionImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateSuperResolutionImageRequest creates a request to invoke GenerateSuperResolutionImage API
func CreateGenerateSuperResolutionImageRequest() (request *GenerateSuperResolutionImageRequest) {
	request = &GenerateSuperResolutionImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "GenerateSuperResolutionImage", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateSuperResolutionImageResponse creates a response to parse from GenerateSuperResolutionImage response
func CreateGenerateSuperResolutionImageResponse() (response *GenerateSuperResolutionImageResponse) {
	response = &GenerateSuperResolutionImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
