package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PubBroadcast invokes the iot.PubBroadcast API synchronously
func (client *Client) PubBroadcast(request *PubBroadcastRequest) (response *PubBroadcastResponse, err error) {
	response = CreatePubBroadcastResponse()
	err = client.DoAction(request, response)
	return
}

// PubBroadcastWithChan invokes the iot.PubBroadcast API asynchronously
func (client *Client) PubBroadcastWithChan(request *PubBroadcastRequest) (<-chan *PubBroadcastResponse, <-chan error) {
	responseChan := make(chan *PubBroadcastResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PubBroadcast(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PubBroadcastWithCallback invokes the iot.PubBroadcast API asynchronously
func (client *Client) PubBroadcastWithCallback(request *PubBroadcastRequest, callback func(response *PubBroadcastResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PubBroadcastResponse
		var err error
		defer close(result)
		response, err = client.PubBroadcast(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PubBroadcastRequest is the request struct for api PubBroadcast
type PubBroadcastRequest struct {
	*requests.RpcRequest
	MessageContent string `position:"Query" name:"MessageContent"`
	IotInstanceId  string `position:"Query" name:"IotInstanceId"`
	TopicFullName  string `position:"Query" name:"TopicFullName"`
	ProductKey     string `position:"Query" name:"ProductKey"`
	ApiProduct     string `position:"Body" name:"ApiProduct"`
	ApiRevision    string `position:"Body" name:"ApiRevision"`
}

// PubBroadcastResponse is the response struct for api PubBroadcast
type PubBroadcastResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	MessageId    int64  `json:"MessageId" xml:"MessageId"`
}

// CreatePubBroadcastRequest creates a request to invoke PubBroadcast API
func CreatePubBroadcastRequest() (request *PubBroadcastRequest) {
	request = &PubBroadcastRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "PubBroadcast", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePubBroadcastResponse creates a response to parse from PubBroadcast response
func CreatePubBroadcastResponse() (response *PubBroadcastResponse) {
	response = &PubBroadcastResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
