package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySpeechLicenseAvailableQuota invokes the iot.QuerySpeechLicenseAvailableQuota API synchronously
func (client *Client) QuerySpeechLicenseAvailableQuota(request *QuerySpeechLicenseAvailableQuotaRequest) (response *QuerySpeechLicenseAvailableQuotaResponse, err error) {
	response = CreateQuerySpeechLicenseAvailableQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySpeechLicenseAvailableQuotaWithChan invokes the iot.QuerySpeechLicenseAvailableQuota API asynchronously
func (client *Client) QuerySpeechLicenseAvailableQuotaWithChan(request *QuerySpeechLicenseAvailableQuotaRequest) (<-chan *QuerySpeechLicenseAvailableQuotaResponse, <-chan error) {
	responseChan := make(chan *QuerySpeechLicenseAvailableQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySpeechLicenseAvailableQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySpeechLicenseAvailableQuotaWithCallback invokes the iot.QuerySpeechLicenseAvailableQuota API asynchronously
func (client *Client) QuerySpeechLicenseAvailableQuotaWithCallback(request *QuerySpeechLicenseAvailableQuotaRequest, callback func(response *QuerySpeechLicenseAvailableQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySpeechLicenseAvailableQuotaResponse
		var err error
		defer close(result)
		response, err = client.QuerySpeechLicenseAvailableQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySpeechLicenseAvailableQuotaRequest is the request struct for api QuerySpeechLicenseAvailableQuota
type QuerySpeechLicenseAvailableQuotaRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QuerySpeechLicenseAvailableQuotaResponse is the response struct for api QuerySpeechLicenseAvailableQuota
type QuerySpeechLicenseAvailableQuotaResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         int64  `json:"Data" xml:"Data"`
}

// CreateQuerySpeechLicenseAvailableQuotaRequest creates a request to invoke QuerySpeechLicenseAvailableQuota API
func CreateQuerySpeechLicenseAvailableQuotaRequest() (request *QuerySpeechLicenseAvailableQuotaRequest) {
	request = &QuerySpeechLicenseAvailableQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySpeechLicenseAvailableQuota", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySpeechLicenseAvailableQuotaResponse creates a response to parse from QuerySpeechLicenseAvailableQuota response
func CreateQuerySpeechLicenseAvailableQuotaResponse() (response *QuerySpeechLicenseAvailableQuotaResponse) {
	response = &QuerySpeechLicenseAvailableQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
