package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshStudioAppTokenOpen invokes the iot.RefreshStudioAppTokenOpen API synchronously
func (client *Client) RefreshStudioAppTokenOpen(request *RefreshStudioAppTokenOpenRequest) (response *RefreshStudioAppTokenOpenResponse, err error) {
	response = CreateRefreshStudioAppTokenOpenResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshStudioAppTokenOpenWithChan invokes the iot.RefreshStudioAppTokenOpen API asynchronously
func (client *Client) RefreshStudioAppTokenOpenWithChan(request *RefreshStudioAppTokenOpenRequest) (<-chan *RefreshStudioAppTokenOpenResponse, <-chan error) {
	responseChan := make(chan *RefreshStudioAppTokenOpenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshStudioAppTokenOpen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshStudioAppTokenOpenWithCallback invokes the iot.RefreshStudioAppTokenOpen API asynchronously
func (client *Client) RefreshStudioAppTokenOpenWithCallback(request *RefreshStudioAppTokenOpenRequest, callback func(response *RefreshStudioAppTokenOpenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshStudioAppTokenOpenResponse
		var err error
		defer close(result)
		response, err = client.RefreshStudioAppTokenOpen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshStudioAppTokenOpenRequest is the request struct for api RefreshStudioAppTokenOpen
type RefreshStudioAppTokenOpenRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ProjectId     string `position:"Body" name:"ProjectId"`
	AppId         string `position:"Body" name:"AppId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// RefreshStudioAppTokenOpenResponse is the response struct for api RefreshStudioAppTokenOpen
type RefreshStudioAppTokenOpenResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateRefreshStudioAppTokenOpenRequest creates a request to invoke RefreshStudioAppTokenOpen API
func CreateRefreshStudioAppTokenOpenRequest() (request *RefreshStudioAppTokenOpenRequest) {
	request = &RefreshStudioAppTokenOpenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "RefreshStudioAppTokenOpen", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshStudioAppTokenOpenResponse creates a response to parse from RefreshStudioAppTokenOpen response
func CreateRefreshStudioAppTokenOpenResponse() (response *RefreshStudioAppTokenOpenResponse) {
	response = &RefreshStudioAppTokenOpenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
