package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLocalFileUploadJob invokes the linkvisual.CreateLocalFileUploadJob API synchronously
func (client *Client) CreateLocalFileUploadJob(request *CreateLocalFileUploadJobRequest) (response *CreateLocalFileUploadJobResponse, err error) {
	response = CreateCreateLocalFileUploadJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLocalFileUploadJobWithChan invokes the linkvisual.CreateLocalFileUploadJob API asynchronously
func (client *Client) CreateLocalFileUploadJobWithChan(request *CreateLocalFileUploadJobRequest) (<-chan *CreateLocalFileUploadJobResponse, <-chan error) {
	responseChan := make(chan *CreateLocalFileUploadJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLocalFileUploadJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLocalFileUploadJobWithCallback invokes the linkvisual.CreateLocalFileUploadJob API asynchronously
func (client *Client) CreateLocalFileUploadJobWithCallback(request *CreateLocalFileUploadJobRequest, callback func(response *CreateLocalFileUploadJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLocalFileUploadJobResponse
		var err error
		defer close(result)
		response, err = client.CreateLocalFileUploadJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLocalFileUploadJobRequest is the request struct for api CreateLocalFileUploadJob
type CreateLocalFileUploadJobRequest struct {
	*requests.RpcRequest
	IotInstanceId string                              `position:"Query" name:"IotInstanceId"`
	TimeSlot      *[]CreateLocalFileUploadJobTimeSlot `position:"Query" name:"TimeSlot"  type:"Repeated"`
	ApiProduct    string                              `position:"Body" name:"ApiProduct"`
	ApiRevision   string                              `position:"Body" name:"ApiRevision"`
}

// CreateLocalFileUploadJobTimeSlot is a repeated param struct in CreateLocalFileUploadJobRequest
type CreateLocalFileUploadJobTimeSlot struct {
	EndTime    string `name:"EndTime"`
	StartTime  string `name:"StartTime"`
	ProductKey string `name:"ProductKey"`
	DeviceName string `name:"DeviceName"`
	IotId      string `name:"IotId"`
}

// CreateLocalFileUploadJobResponse is the response struct for api CreateLocalFileUploadJob
type CreateLocalFileUploadJobResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateCreateLocalFileUploadJobRequest creates a request to invoke CreateLocalFileUploadJob API
func CreateCreateLocalFileUploadJobRequest() (request *CreateLocalFileUploadJobRequest) {
	request = &CreateLocalFileUploadJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "CreateLocalFileUploadJob", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLocalFileUploadJobResponse creates a response to parse from CreateLocalFileUploadJob response
func CreateCreateLocalFileUploadJobResponse() (response *CreateLocalFileUploadJobResponse) {
	response = &CreateLocalFileUploadJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
