package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTimeTemplate invokes the linkvisual.DeleteTimeTemplate API synchronously
func (client *Client) DeleteTimeTemplate(request *DeleteTimeTemplateRequest) (response *DeleteTimeTemplateResponse, err error) {
	response = CreateDeleteTimeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTimeTemplateWithChan invokes the linkvisual.DeleteTimeTemplate API asynchronously
func (client *Client) DeleteTimeTemplateWithChan(request *DeleteTimeTemplateRequest) (<-chan *DeleteTimeTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteTimeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTimeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTimeTemplateWithCallback invokes the linkvisual.DeleteTimeTemplate API asynchronously
func (client *Client) DeleteTimeTemplateWithCallback(request *DeleteTimeTemplateRequest, callback func(response *DeleteTimeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTimeTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteTimeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTimeTemplateRequest is the request struct for api DeleteTimeTemplate
type DeleteTimeTemplateRequest struct {
	*requests.RpcRequest
	TemplateId  string `position:"Query" name:"TemplateId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// DeleteTimeTemplateResponse is the response struct for api DeleteTimeTemplate
type DeleteTimeTemplateResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteTimeTemplateRequest creates a request to invoke DeleteTimeTemplate API
func CreateDeleteTimeTemplateRequest() (request *DeleteTimeTemplateRequest) {
	request = &DeleteTimeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "DeleteTimeTemplate", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTimeTemplateResponse creates a response to parse from DeleteTimeTemplate response
func CreateDeleteTimeTemplateResponse() (response *DeleteTimeTemplateResponse) {
	response = &DeleteTimeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
