package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceUser invokes the linkvisual.QueryFaceUser API synchronously
func (client *Client) QueryFaceUser(request *QueryFaceUserRequest) (response *QueryFaceUserResponse, err error) {
	response = CreateQueryFaceUserResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceUserWithChan invokes the linkvisual.QueryFaceUser API asynchronously
func (client *Client) QueryFaceUserWithChan(request *QueryFaceUserRequest) (<-chan *QueryFaceUserResponse, <-chan error) {
	responseChan := make(chan *QueryFaceUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceUserWithCallback invokes the linkvisual.QueryFaceUser API asynchronously
func (client *Client) QueryFaceUserWithCallback(request *QueryFaceUserRequest, callback func(response *QueryFaceUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceUserResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceUserRequest is the request struct for api QueryFaceUser
type QueryFaceUserRequest struct {
	*requests.RpcRequest
	IsolationId string `position:"Query" name:"IsolationId"`
	UserId      string `position:"Query" name:"UserId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// QueryFaceUserResponse is the response struct for api QueryFaceUser
type QueryFaceUserResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceUserRequest creates a request to invoke QueryFaceUser API
func CreateQueryFaceUserRequest() (request *QueryFaceUserRequest) {
	request = &QueryFaceUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceUser", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceUserResponse creates a response to parse from QueryFaceUser response
func CreateQueryFaceUserResponse() (response *QueryFaceUserResponse) {
	response = &QueryFaceUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
