package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMcubeMiniPackages invokes the mpaas.ListMcubeMiniPackages API synchronously
func (client *Client) ListMcubeMiniPackages(request *ListMcubeMiniPackagesRequest) (response *ListMcubeMiniPackagesResponse, err error) {
	response = CreateListMcubeMiniPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMcubeMiniPackagesWithChan invokes the mpaas.ListMcubeMiniPackages API asynchronously
func (client *Client) ListMcubeMiniPackagesWithChan(request *ListMcubeMiniPackagesRequest) (<-chan *ListMcubeMiniPackagesResponse, <-chan error) {
	responseChan := make(chan *ListMcubeMiniPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMcubeMiniPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMcubeMiniPackagesWithCallback invokes the mpaas.ListMcubeMiniPackages API asynchronously
func (client *Client) ListMcubeMiniPackagesWithCallback(request *ListMcubeMiniPackagesRequest, callback func(response *ListMcubeMiniPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMcubeMiniPackagesResponse
		var err error
		defer close(result)
		response, err = client.ListMcubeMiniPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMcubeMiniPackagesRequest is the request struct for api ListMcubeMiniPackages
type ListMcubeMiniPackagesRequest struct {
	*requests.RpcRequest
	H5Id         string `position:"Body" name:"H5Id"`
	TenantId     string `position:"Body" name:"TenantId"`
	AppId        string `position:"Body" name:"AppId"`
	PackageTypes string `position:"Body" name:"PackageTypes"`
	WorkspaceId  string `position:"Body" name:"WorkspaceId"`
}

// ListMcubeMiniPackagesResponse is the response struct for api ListMcubeMiniPackages
type ListMcubeMiniPackagesResponse struct {
	*responses.BaseResponse
	ResultMessage         string                `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode            string                `json:"ResultCode" xml:"ResultCode"`
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	ListMiniPackageResult ListMiniPackageResult `json:"ListMiniPackageResult" xml:"ListMiniPackageResult"`
}

// CreateListMcubeMiniPackagesRequest creates a request to invoke ListMcubeMiniPackages API
func CreateListMcubeMiniPackagesRequest() (request *ListMcubeMiniPackagesRequest) {
	request = &ListMcubeMiniPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMcubeMiniPackages", "", "")
	request.Method = requests.POST
	return
}

// CreateListMcubeMiniPackagesResponse creates a response to parse from ListMcubeMiniPackages response
func CreateListMcubeMiniPackagesResponse() (response *ListMcubeMiniPackagesResponse) {
	response = &ListMcubeMiniPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
