package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayIsolationRule invokes the mse.CreateGatewayIsolationRule API synchronously
func (client *Client) CreateGatewayIsolationRule(request *CreateGatewayIsolationRuleRequest) (response *CreateGatewayIsolationRuleResponse, err error) {
	response = CreateCreateGatewayIsolationRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayIsolationRuleWithChan invokes the mse.CreateGatewayIsolationRule API asynchronously
func (client *Client) CreateGatewayIsolationRuleWithChan(request *CreateGatewayIsolationRuleRequest) (<-chan *CreateGatewayIsolationRuleResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayIsolationRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayIsolationRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayIsolationRuleWithCallback invokes the mse.CreateGatewayIsolationRule API asynchronously
func (client *Client) CreateGatewayIsolationRuleWithCallback(request *CreateGatewayIsolationRuleRequest, callback func(response *CreateGatewayIsolationRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayIsolationRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayIsolationRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayIsolationRuleRequest is the request struct for api CreateGatewayIsolationRule
type CreateGatewayIsolationRuleRequest struct {
	*requests.RpcRequest
	MseSessionId        string           `position:"Query" name:"MseSessionId"`
	BehaviorType        requests.Integer `position:"Query" name:"BehaviorType"`
	Enable              requests.Integer `position:"Query" name:"Enable"`
	GatewayId           requests.Integer `position:"Query" name:"GatewayId"`
	ResponseStatusCode  requests.Integer `position:"Query" name:"ResponseStatusCode"`
	RouteId             requests.Integer `position:"Query" name:"RouteId"`
	GatewayUniqueId     string           `position:"Query" name:"GatewayUniqueId"`
	BodyEncoding        requests.Integer `position:"Query" name:"BodyEncoding"`
	ResponseRedirectUrl string           `position:"Query" name:"ResponseRedirectUrl"`
	RouteName           string           `position:"Query" name:"RouteName"`
	AcceptLanguage      string           `position:"Query" name:"AcceptLanguage"`
	MaxConcurrency      requests.Integer `position:"Query" name:"MaxConcurrency"`
	ResponseContentBody string           `position:"Query" name:"ResponseContentBody"`
}

// CreateGatewayIsolationRuleResponse is the response struct for api CreateGatewayIsolationRule
type CreateGatewayIsolationRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int64  `json:"Data" xml:"Data"`
}

// CreateCreateGatewayIsolationRuleRequest creates a request to invoke CreateGatewayIsolationRule API
func CreateCreateGatewayIsolationRuleRequest() (request *CreateGatewayIsolationRuleRequest) {
	request = &CreateGatewayIsolationRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateGatewayIsolationRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayIsolationRuleResponse creates a response to parse from CreateGatewayIsolationRule response
func CreateCreateGatewayIsolationRuleResponse() (response *CreateGatewayIsolationRuleResponse) {
	response = &CreateGatewayIsolationRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
