package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNetworkReachableAnalysis invokes the nis.DeleteNetworkReachableAnalysis API synchronously
func (client *Client) DeleteNetworkReachableAnalysis(request *DeleteNetworkReachableAnalysisRequest) (response *DeleteNetworkReachableAnalysisResponse, err error) {
	response = CreateDeleteNetworkReachableAnalysisResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNetworkReachableAnalysisWithChan invokes the nis.DeleteNetworkReachableAnalysis API asynchronously
func (client *Client) DeleteNetworkReachableAnalysisWithChan(request *DeleteNetworkReachableAnalysisRequest) (<-chan *DeleteNetworkReachableAnalysisResponse, <-chan error) {
	responseChan := make(chan *DeleteNetworkReachableAnalysisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNetworkReachableAnalysis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNetworkReachableAnalysisWithCallback invokes the nis.DeleteNetworkReachableAnalysis API asynchronously
func (client *Client) DeleteNetworkReachableAnalysisWithCallback(request *DeleteNetworkReachableAnalysisRequest, callback func(response *DeleteNetworkReachableAnalysisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNetworkReachableAnalysisResponse
		var err error
		defer close(result)
		response, err = client.DeleteNetworkReachableAnalysis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNetworkReachableAnalysisRequest is the request struct for api DeleteNetworkReachableAnalysis
type DeleteNetworkReachableAnalysisRequest struct {
	*requests.RpcRequest
	DryRun                      requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken                 string           `position:"Query" name:"ClientToken"`
	NetworkReachableAnalysisIds *[]string        `position:"Query" name:"NetworkReachableAnalysisIds"  type:"Json"`
}

// DeleteNetworkReachableAnalysisResponse is the response struct for api DeleteNetworkReachableAnalysis
type DeleteNetworkReachableAnalysisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteNetworkReachableAnalysisRequest creates a request to invoke DeleteNetworkReachableAnalysis API
func CreateDeleteNetworkReachableAnalysisRequest() (request *DeleteNetworkReachableAnalysisRequest) {
	request = &DeleteNetworkReachableAnalysisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "DeleteNetworkReachableAnalysis", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNetworkReachableAnalysisResponse creates a response to parse from DeleteNetworkReachableAnalysis response
func CreateDeleteNetworkReachableAnalysisResponse() (response *DeleteNetworkReachableAnalysisResponse) {
	response = &DeleteNetworkReachableAnalysisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
