package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOamUserByAliyunId invokes the oam.GetOamUserByAliyunId API synchronously
// api document: https://help.aliyun.com/api/oam/getoamuserbyaliyunid.html
func (client *Client) GetOamUserByAliyunId(request *GetOamUserByAliyunIdRequest) (response *GetOamUserByAliyunIdResponse, err error) {
	response = CreateGetOamUserByAliyunIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetOamUserByAliyunIdWithChan invokes the oam.GetOamUserByAliyunId API asynchronously
// api document: https://help.aliyun.com/api/oam/getoamuserbyaliyunid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOamUserByAliyunIdWithChan(request *GetOamUserByAliyunIdRequest) (<-chan *GetOamUserByAliyunIdResponse, <-chan error) {
	responseChan := make(chan *GetOamUserByAliyunIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOamUserByAliyunId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOamUserByAliyunIdWithCallback invokes the oam.GetOamUserByAliyunId API asynchronously
// api document: https://help.aliyun.com/api/oam/getoamuserbyaliyunid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOamUserByAliyunIdWithCallback(request *GetOamUserByAliyunIdRequest, callback func(response *GetOamUserByAliyunIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOamUserByAliyunIdResponse
		var err error
		defer close(result)
		response, err = client.GetOamUserByAliyunId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOamUserByAliyunIdRequest is the request struct for api GetOamUserByAliyunId
type GetOamUserByAliyunIdRequest struct {
	*requests.RpcRequest
	AliyunId string `position:"Query" name:"AliyunId"`
}

// GetOamUserByAliyunIdResponse is the response struct for api GetOamUserByAliyunId
type GetOamUserByAliyunIdResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
	Data    Data   `json:"Data" xml:"Data"`
}

// CreateGetOamUserByAliyunIdRequest creates a request to invoke GetOamUserByAliyunId API
func CreateGetOamUserByAliyunIdRequest() (request *GetOamUserByAliyunIdRequest) {
	request = &GetOamUserByAliyunIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "GetOamUserByAliyunId", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOamUserByAliyunIdResponse creates a response to parse from GetOamUserByAliyunId response
func CreateGetOamUserByAliyunIdResponse() (response *GetOamUserByAliyunIdResponse) {
	response = &GetOamUserByAliyunIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
