package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantReadableScn invokes the oceanbasepro.DescribeTenantReadableScn API synchronously
func (client *Client) DescribeTenantReadableScn(request *DescribeTenantReadableScnRequest) (response *DescribeTenantReadableScnResponse, err error) {
	response = CreateDescribeTenantReadableScnResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantReadableScnWithChan invokes the oceanbasepro.DescribeTenantReadableScn API asynchronously
func (client *Client) DescribeTenantReadableScnWithChan(request *DescribeTenantReadableScnRequest) (<-chan *DescribeTenantReadableScnResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantReadableScnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantReadableScn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantReadableScnWithCallback invokes the oceanbasepro.DescribeTenantReadableScn API asynchronously
func (client *Client) DescribeTenantReadableScnWithCallback(request *DescribeTenantReadableScnRequest, callback func(response *DescribeTenantReadableScnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantReadableScnResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantReadableScn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantReadableScnRequest is the request struct for api DescribeTenantReadableScn
type DescribeTenantReadableScnRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body" name:"InstanceId"`
	TenantId   string `position:"Body" name:"TenantId"`
}

// DescribeTenantReadableScnResponse is the response struct for api DescribeTenantReadableScn
type DescribeTenantReadableScnResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeTenantReadableScnRequest creates a request to invoke DescribeTenantReadableScn API
func CreateDescribeTenantReadableScnRequest() (request *DescribeTenantReadableScnRequest) {
	request = &DescribeTenantReadableScnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantReadableScn", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantReadableScnResponse creates a response to parse from DescribeTenantReadableScn response
func CreateDescribeTenantReadableScnResponse() (response *DescribeTenantReadableScnResponse) {
	response = &DescribeTenantReadableScnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
