package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAppGroupQuota invokes the opensearch.ModifyAppGroupQuota API synchronously
func (client *Client) ModifyAppGroupQuota(request *ModifyAppGroupQuotaRequest) (response *ModifyAppGroupQuotaResponse, err error) {
	response = CreateModifyAppGroupQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAppGroupQuotaWithChan invokes the opensearch.ModifyAppGroupQuota API asynchronously
func (client *Client) ModifyAppGroupQuotaWithChan(request *ModifyAppGroupQuotaRequest) (<-chan *ModifyAppGroupQuotaResponse, <-chan error) {
	responseChan := make(chan *ModifyAppGroupQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAppGroupQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAppGroupQuotaWithCallback invokes the opensearch.ModifyAppGroupQuota API asynchronously
func (client *Client) ModifyAppGroupQuotaWithCallback(request *ModifyAppGroupQuotaRequest, callback func(response *ModifyAppGroupQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAppGroupQuotaResponse
		var err error
		defer close(result)
		response, err = client.ModifyAppGroupQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAppGroupQuotaRequest is the request struct for api ModifyAppGroupQuota
type ModifyAppGroupQuotaRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ModifyAppGroupQuotaResponse is the response struct for api ModifyAppGroupQuota
type ModifyAppGroupQuotaResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"requestId" xml:"requestId"`
	Result    ResultInModifyAppGroupQuota `json:"result" xml:"result"`
}

// CreateModifyAppGroupQuotaRequest creates a request to invoke ModifyAppGroupQuota API
func CreateModifyAppGroupQuotaRequest() (request *ModifyAppGroupQuotaRequest) {
	request = &ModifyAppGroupQuotaRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ModifyAppGroupQuota", "/v4/openapi/app-groups/[appGroupIdentity]/quota", "", "")
	request.Method = requests.PUT
	return
}

// CreateModifyAppGroupQuotaResponse creates a response to parse from ModifyAppGroupQuota response
func CreateModifyAppGroupQuotaResponse() (response *ModifyAppGroupQuotaResponse) {
	response = &ModifyAppGroupQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
