package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchInstanceNetType invokes the petadata.SwitchInstanceNetType API synchronously
// api document: https://help.aliyun.com/api/petadata/switchinstancenettype.html
func (client *Client) SwitchInstanceNetType(request *SwitchInstanceNetTypeRequest) (response *SwitchInstanceNetTypeResponse, err error) {
	response = CreateSwitchInstanceNetTypeResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchInstanceNetTypeWithChan invokes the petadata.SwitchInstanceNetType API asynchronously
// api document: https://help.aliyun.com/api/petadata/switchinstancenettype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwitchInstanceNetTypeWithChan(request *SwitchInstanceNetTypeRequest) (<-chan *SwitchInstanceNetTypeResponse, <-chan error) {
	responseChan := make(chan *SwitchInstanceNetTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchInstanceNetType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchInstanceNetTypeWithCallback invokes the petadata.SwitchInstanceNetType API asynchronously
// api document: https://help.aliyun.com/api/petadata/switchinstancenettype.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwitchInstanceNetTypeWithCallback(request *SwitchInstanceNetTypeRequest, callback func(response *SwitchInstanceNetTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchInstanceNetTypeResponse
		var err error
		defer close(result)
		response, err = client.SwitchInstanceNetType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchInstanceNetTypeRequest is the request struct for api SwitchInstanceNetType
type SwitchInstanceNetTypeRequest struct {
	*requests.RpcRequest
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	TargetNetworkType    string           `position:"Query" name:"TargetNetworkType"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpcId                string           `position:"Query" name:"VpcId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SwitchInstanceNetTypeResponse is the response struct for api SwitchInstanceNetType
type SwitchInstanceNetTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwitchInstanceNetTypeRequest creates a request to invoke SwitchInstanceNetType API
func CreateSwitchInstanceNetTypeRequest() (request *SwitchInstanceNetTypeRequest) {
	request = &SwitchInstanceNetTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "SwitchInstanceNetType", "petadata", "openAPI")
	return
}

// CreateSwitchInstanceNetTypeResponse creates a response to parse from SwitchInstanceNetType response
func CreateSwitchInstanceNetTypeResponse() (response *SwitchInstanceNetTypeResponse) {
	response = &SwitchInstanceNetTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
