package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrganizationRoles invokes the quickbi_public.ListOrganizationRoles API synchronously
func (client *Client) ListOrganizationRoles(request *ListOrganizationRolesRequest) (response *ListOrganizationRolesResponse, err error) {
	response = CreateListOrganizationRolesResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrganizationRolesWithChan invokes the quickbi_public.ListOrganizationRoles API asynchronously
func (client *Client) ListOrganizationRolesWithChan(request *ListOrganizationRolesRequest) (<-chan *ListOrganizationRolesResponse, <-chan error) {
	responseChan := make(chan *ListOrganizationRolesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrganizationRoles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrganizationRolesWithCallback invokes the quickbi_public.ListOrganizationRoles API asynchronously
func (client *Client) ListOrganizationRolesWithCallback(request *ListOrganizationRolesRequest, callback func(response *ListOrganizationRolesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrganizationRolesResponse
		var err error
		defer close(result)
		response, err = client.ListOrganizationRoles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrganizationRolesRequest is the request struct for api ListOrganizationRoles
type ListOrganizationRolesRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
}

// ListOrganizationRolesResponse is the response struct for api ListOrganizationRoles
type ListOrganizationRolesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateListOrganizationRolesRequest creates a request to invoke ListOrganizationRoles API
func CreateListOrganizationRolesRequest() (request *ListOrganizationRolesRequest) {
	request = &ListOrganizationRolesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "ListOrganizationRoles", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListOrganizationRolesResponse creates a response to parse from ListOrganizationRoles response
func CreateListOrganizationRolesResponse() (response *ListOrganizationRolesResponse) {
	response = &ListOrganizationRolesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
