package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeKmsAssociateResources invokes the rds.DescribeKmsAssociateResources API synchronously
func (client *Client) DescribeKmsAssociateResources(request *DescribeKmsAssociateResourcesRequest) (response *DescribeKmsAssociateResourcesResponse, err error) {
	response = CreateDescribeKmsAssociateResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeKmsAssociateResourcesWithChan invokes the rds.DescribeKmsAssociateResources API asynchronously
func (client *Client) DescribeKmsAssociateResourcesWithChan(request *DescribeKmsAssociateResourcesRequest) (<-chan *DescribeKmsAssociateResourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeKmsAssociateResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeKmsAssociateResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeKmsAssociateResourcesWithCallback invokes the rds.DescribeKmsAssociateResources API asynchronously
func (client *Client) DescribeKmsAssociateResourcesWithCallback(request *DescribeKmsAssociateResourcesRequest, callback func(response *DescribeKmsAssociateResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeKmsAssociateResourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeKmsAssociateResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeKmsAssociateResourcesRequest is the request struct for api DescribeKmsAssociateResources
type DescribeKmsAssociateResourcesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	KmsResourceRegionId  string           `position:"Query" name:"KmsResourceRegionId"`
	KmsResourceUser      string           `position:"Query" name:"KmsResourceUser"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	KmsResourceId        string           `position:"Query" name:"KmsResourceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
	KmsResourceType      string           `position:"Query" name:"KmsResourceType"`
}

// DescribeKmsAssociateResourcesResponse is the response struct for api DescribeKmsAssociateResources
type DescribeKmsAssociateResourcesResponse struct {
	*responses.BaseResponse
	RequestId            string       `json:"RequestId" xml:"RequestId"`
	AssociateStatus      bool         `json:"AssociateStatus" xml:"AssociateStatus"`
	AssociateDBInstances []DBInstance `json:"AssociateDBInstances" xml:"AssociateDBInstances"`
}

// CreateDescribeKmsAssociateResourcesRequest creates a request to invoke DescribeKmsAssociateResources API
func CreateDescribeKmsAssociateResourcesRequest() (request *DescribeKmsAssociateResourcesRequest) {
	request = &DescribeKmsAssociateResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeKmsAssociateResources", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeKmsAssociateResourcesResponse creates a response to parse from DescribeKmsAssociateResources response
func CreateDescribeKmsAssociateResourcesResponse() (response *DescribeKmsAssociateResourcesResponse) {
	response = &DescribeKmsAssociateResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
