package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCustinsResource invokes the rds.ModifyCustinsResource API synchronously
func (client *Client) ModifyCustinsResource(request *ModifyCustinsResourceRequest) (response *ModifyCustinsResourceResponse, err error) {
	response = CreateModifyCustinsResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCustinsResourceWithChan invokes the rds.ModifyCustinsResource API asynchronously
func (client *Client) ModifyCustinsResourceWithChan(request *ModifyCustinsResourceRequest) (<-chan *ModifyCustinsResourceResponse, <-chan error) {
	responseChan := make(chan *ModifyCustinsResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCustinsResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCustinsResourceWithCallback invokes the rds.ModifyCustinsResource API asynchronously
func (client *Client) ModifyCustinsResourceWithCallback(request *ModifyCustinsResourceRequest, callback func(response *ModifyCustinsResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCustinsResourceResponse
		var err error
		defer close(result)
		response, err = client.ModifyCustinsResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCustinsResourceRequest is the request struct for api ModifyCustinsResource
type ModifyCustinsResourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId              requests.Integer `position:"Query" name:"ResourceOwnerId"`
	IncreaseRatio                string           `position:"Query" name:"IncreaseRatio"`
	RestoreOriginalSpecification string           `position:"Query" name:"RestoreOriginalSpecification"`
	DBInstanceId                 string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount         string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId                      requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType                 string           `position:"Query" name:"ResourceType"`
	AdjustDeadline               string           `position:"Query" name:"AdjustDeadline"`
	TargetValue                  requests.Integer `position:"Query" name:"TargetValue"`
}

// ModifyCustinsResourceResponse is the response struct for api ModifyCustinsResource
type ModifyCustinsResourceResponse struct {
	*responses.BaseResponse
	TaskId    int    `json:"TaskId" xml:"TaskId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCustinsResourceRequest creates a request to invoke ModifyCustinsResource API
func CreateModifyCustinsResourceRequest() (request *ModifyCustinsResourceRequest) {
	request = &ModifyCustinsResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyCustinsResource", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCustinsResourceResponse creates a response to parse from ModifyCustinsResource response
func CreateModifyCustinsResourceResponse() (response *ModifyCustinsResourceResponse) {
	response = &ModifyCustinsResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
