package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckAccountDelete invokes the resourcemanager.CheckAccountDelete API synchronously
func (client *Client) CheckAccountDelete(request *CheckAccountDeleteRequest) (response *CheckAccountDeleteResponse, err error) {
	response = CreateCheckAccountDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// CheckAccountDeleteWithChan invokes the resourcemanager.CheckAccountDelete API asynchronously
func (client *Client) CheckAccountDeleteWithChan(request *CheckAccountDeleteRequest) (<-chan *CheckAccountDeleteResponse, <-chan error) {
	responseChan := make(chan *CheckAccountDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckAccountDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckAccountDeleteWithCallback invokes the resourcemanager.CheckAccountDelete API asynchronously
func (client *Client) CheckAccountDeleteWithCallback(request *CheckAccountDeleteRequest, callback func(response *CheckAccountDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckAccountDeleteResponse
		var err error
		defer close(result)
		response, err = client.CheckAccountDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckAccountDeleteRequest is the request struct for api CheckAccountDelete
type CheckAccountDeleteRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// CheckAccountDeleteResponse is the response struct for api CheckAccountDelete
type CheckAccountDeleteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckAccountDeleteRequest creates a request to invoke CheckAccountDelete API
func CreateCheckAccountDeleteRequest() (request *CheckAccountDeleteRequest) {
	request = &CheckAccountDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "CheckAccountDelete", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckAccountDeleteResponse creates a response to parse from CheckAccountDelete response
func CreateCheckAccountDeleteResponse() (response *CheckAccountDeleteResponse) {
	response = &CheckAccountDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
