package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAutoGroupingRule invokes the resourcemanager.UpdateAutoGroupingRule API synchronously
func (client *Client) UpdateAutoGroupingRule(request *UpdateAutoGroupingRuleRequest) (response *UpdateAutoGroupingRuleResponse, err error) {
	response = CreateUpdateAutoGroupingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAutoGroupingRuleWithChan invokes the resourcemanager.UpdateAutoGroupingRule API asynchronously
func (client *Client) UpdateAutoGroupingRuleWithChan(request *UpdateAutoGroupingRuleRequest) (<-chan *UpdateAutoGroupingRuleResponse, <-chan error) {
	responseChan := make(chan *UpdateAutoGroupingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAutoGroupingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAutoGroupingRuleWithCallback invokes the resourcemanager.UpdateAutoGroupingRule API asynchronously
func (client *Client) UpdateAutoGroupingRuleWithCallback(request *UpdateAutoGroupingRuleRequest, callback func(response *UpdateAutoGroupingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAutoGroupingRuleResponse
		var err error
		defer close(result)
		response, err = client.UpdateAutoGroupingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAutoGroupingRuleRequest is the request struct for api UpdateAutoGroupingRule
type UpdateAutoGroupingRuleRequest struct {
	*requests.RpcRequest
	RuleDesc                     string                                `position:"Query" name:"RuleDesc"`
	ResourceTypesScope           string                                `position:"Query" name:"ResourceTypesScope"`
	RuleName                     string                                `position:"Query" name:"RuleName"`
	ExcludeResourceGroupIdsScope string                                `position:"Query" name:"ExcludeResourceGroupIdsScope"`
	RegionIdsScope               string                                `position:"Query" name:"RegionIdsScope"`
	ResourceIdsScope             string                                `position:"Query" name:"ResourceIdsScope"`
	RuleContents                 *[]UpdateAutoGroupingRuleRuleContents `position:"Query" name:"RuleContents"  type:"Repeated"`
	ExcludeResourceTypesScope    string                                `position:"Query" name:"ExcludeResourceTypesScope"`
	ResourceGroupIdsScope        string                                `position:"Query" name:"ResourceGroupIdsScope"`
	ExcludeRegionIdsScope        string                                `position:"Query" name:"ExcludeRegionIdsScope"`
	ExcludeResourceIdsScope      string                                `position:"Query" name:"ExcludeResourceIdsScope"`
	RuleId                       string                                `position:"Query" name:"RuleId"`
}

// UpdateAutoGroupingRuleRuleContents is a repeated param struct in UpdateAutoGroupingRuleRequest
type UpdateAutoGroupingRuleRuleContents struct {
	RuleContentId                string `name:"RuleContentId"`
	TargetResourceGroupCondition string `name:"TargetResourceGroupCondition"`
	AutoGroupingScopeCondition   string `name:"AutoGroupingScopeCondition"`
}

// UpdateAutoGroupingRuleResponse is the response struct for api UpdateAutoGroupingRule
type UpdateAutoGroupingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAutoGroupingRuleRequest creates a request to invoke UpdateAutoGroupingRule API
func CreateUpdateAutoGroupingRuleRequest() (request *UpdateAutoGroupingRuleRequest) {
	request = &UpdateAutoGroupingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "UpdateAutoGroupingRule", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAutoGroupingRuleResponse creates a response to parse from UpdateAutoGroupingRule response
func CreateUpdateAutoGroupingRuleResponse() (response *UpdateAutoGroupingRuleResponse) {
	response = &UpdateAutoGroupingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
