package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AudienceMemberQuery invokes the retailadvqa_public.AudienceMemberQuery API synchronously
func (client *Client) AudienceMemberQuery(request *AudienceMemberQueryRequest) (response *AudienceMemberQueryResponse, err error) {
	response = CreateAudienceMemberQueryResponse()
	err = client.DoAction(request, response)
	return
}

// AudienceMemberQueryWithChan invokes the retailadvqa_public.AudienceMemberQuery API asynchronously
func (client *Client) AudienceMemberQueryWithChan(request *AudienceMemberQueryRequest) (<-chan *AudienceMemberQueryResponse, <-chan error) {
	responseChan := make(chan *AudienceMemberQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AudienceMemberQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AudienceMemberQueryWithCallback invokes the retailadvqa_public.AudienceMemberQuery API asynchronously
func (client *Client) AudienceMemberQueryWithCallback(request *AudienceMemberQueryRequest, callback func(response *AudienceMemberQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AudienceMemberQueryResponse
		var err error
		defer close(result)
		response, err = client.AudienceMemberQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AudienceMemberQueryRequest is the request struct for api AudienceMemberQuery
type AudienceMemberQueryRequest struct {
	*requests.RpcRequest
	AccessId     string `position:"Query" name:"AccessId"`
	Delimiter    string `position:"Query" name:"Delimiter"`
	AudienceId   string `position:"Query" name:"AudienceId"`
	WorkspaceId  string `position:"Query" name:"WorkspaceId"`
	MappingTypes string `position:"Query" name:"MappingTypes"`
}

// AudienceMemberQueryResponse is the response struct for api AudienceMemberQuery
type AudienceMemberQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateAudienceMemberQueryRequest creates a request to invoke AudienceMemberQuery API
func CreateAudienceMemberQueryRequest() (request *AudienceMemberQueryRequest) {
	request = &AudienceMemberQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "AudienceMemberQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateAudienceMemberQueryResponse creates a response to parse from AudienceMemberQuery response
func CreateAudienceMemberQueryResponse() (response *AudienceMemberQueryResponse) {
	response = &AudienceMemberQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
