package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConsumeResPacks invokes the retailadvqa_public.ConsumeResPacks API synchronously
func (client *Client) ConsumeResPacks(request *ConsumeResPacksRequest) (response *ConsumeResPacksResponse, err error) {
	response = CreateConsumeResPacksResponse()
	err = client.DoAction(request, response)
	return
}

// ConsumeResPacksWithChan invokes the retailadvqa_public.ConsumeResPacks API asynchronously
func (client *Client) ConsumeResPacksWithChan(request *ConsumeResPacksRequest) (<-chan *ConsumeResPacksResponse, <-chan error) {
	responseChan := make(chan *ConsumeResPacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConsumeResPacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConsumeResPacksWithCallback invokes the retailadvqa_public.ConsumeResPacks API asynchronously
func (client *Client) ConsumeResPacksWithCallback(request *ConsumeResPacksRequest, callback func(response *ConsumeResPacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConsumeResPacksResponse
		var err error
		defer close(result)
		response, err = client.ConsumeResPacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConsumeResPacksRequest is the request struct for api ConsumeResPacks
type ConsumeResPacksRequest struct {
	*requests.RpcRequest
	AccessId     string           `position:"Query" name:"AccessId"`
	Template     string           `position:"Query" name:"Template"`
	ConsumeType  string           `position:"Query" name:"ConsumeType"`
	ProductId    string           `position:"Query" name:"ProductId"`
	ConsumeInfos string           `position:"Body" name:"ConsumeInfos"`
	TenantId     string           `position:"Query" name:"TenantId"`
	ConsumeTime  requests.Integer `position:"Query" name:"ConsumeTime"`
}

// ConsumeResPacksResponse is the response struct for api ConsumeResPacks
type ConsumeResPacksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateConsumeResPacksRequest creates a request to invoke ConsumeResPacks API
func CreateConsumeResPacksRequest() (request *ConsumeResPacksRequest) {
	request = &ConsumeResPacksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ConsumeResPacks", "", "")
	request.Method = requests.POST
	return
}

// CreateConsumeResPacksResponse creates a response to parse from ConsumeResPacks response
func CreateConsumeResPacksResponse() (response *ConsumeResPacksResponse) {
	response = &ConsumeResPacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
