package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// WorkSaveAudience invokes the retailadvqa_public.WorkSaveAudience API synchronously
func (client *Client) WorkSaveAudience(request *WorkSaveAudienceRequest) (response *WorkSaveAudienceResponse, err error) {
	response = CreateWorkSaveAudienceResponse()
	err = client.DoAction(request, response)
	return
}

// WorkSaveAudienceWithChan invokes the retailadvqa_public.WorkSaveAudience API asynchronously
func (client *Client) WorkSaveAudienceWithChan(request *WorkSaveAudienceRequest) (<-chan *WorkSaveAudienceResponse, <-chan error) {
	responseChan := make(chan *WorkSaveAudienceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.WorkSaveAudience(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// WorkSaveAudienceWithCallback invokes the retailadvqa_public.WorkSaveAudience API asynchronously
func (client *Client) WorkSaveAudienceWithCallback(request *WorkSaveAudienceRequest, callback func(response *WorkSaveAudienceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *WorkSaveAudienceResponse
		var err error
		defer close(result)
		response, err = client.WorkSaveAudience(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// WorkSaveAudienceRequest is the request struct for api WorkSaveAudience
type WorkSaveAudienceRequest struct {
	*requests.RpcRequest
	AudienceName string `position:"Query" name:"AudienceName"`
	Instance     string `position:"Query" name:"Instance"`
	MappingType  string `position:"Query" name:"MappingType"`
	DsType       string `position:"Query" name:"DsType"`
	DbSchema     string `position:"Query" name:"DbSchema"`
	ExportField  string `position:"Query" name:"ExportField"`
	EncryType    string `position:"Query" name:"EncryType"`
	UserId       string `position:"Query" name:"UserId"`
	AccessId     string `position:"Query" name:"AccessId"`
	ConnStr      string `position:"Query" name:"ConnStr"`
	Statement    string `position:"Query" name:"Statement"`
	WorkspaceId  string `position:"Query" name:"WorkspaceId"`
}

// WorkSaveAudienceResponse is the response struct for api WorkSaveAudience
type WorkSaveAudienceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
}

// CreateWorkSaveAudienceRequest creates a request to invoke WorkSaveAudience API
func CreateWorkSaveAudienceRequest() (request *WorkSaveAudienceRequest) {
	request = &WorkSaveAudienceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "WorkSaveAudience", "", "")
	request.Method = requests.POST
	return
}

// CreateWorkSaveAudienceResponse creates a response to parse from WorkSaveAudience response
func CreateWorkSaveAudienceResponse() (response *WorkSaveAudienceResponse) {
	response = &WorkSaveAudienceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
