package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageScanAuthCount invokes the sas.DescribeImageScanAuthCount API synchronously
func (client *Client) DescribeImageScanAuthCount(request *DescribeImageScanAuthCountRequest) (response *DescribeImageScanAuthCountResponse, err error) {
	response = CreateDescribeImageScanAuthCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageScanAuthCountWithChan invokes the sas.DescribeImageScanAuthCount API asynchronously
func (client *Client) DescribeImageScanAuthCountWithChan(request *DescribeImageScanAuthCountRequest) (<-chan *DescribeImageScanAuthCountResponse, <-chan error) {
	responseChan := make(chan *DescribeImageScanAuthCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageScanAuthCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageScanAuthCountWithCallback invokes the sas.DescribeImageScanAuthCount API asynchronously
func (client *Client) DescribeImageScanAuthCountWithCallback(request *DescribeImageScanAuthCountRequest, callback func(response *DescribeImageScanAuthCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageScanAuthCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageScanAuthCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageScanAuthCountRequest is the request struct for api DescribeImageScanAuthCount
type DescribeImageScanAuthCountRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeImageScanAuthCountResponse is the response struct for api DescribeImageScanAuthCount
type DescribeImageScanAuthCountResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	ImageScan ImageScan `json:"ImageScan" xml:"ImageScan"`
}

// CreateDescribeImageScanAuthCountRequest creates a request to invoke DescribeImageScanAuthCount API
func CreateDescribeImageScanAuthCountRequest() (request *DescribeImageScanAuthCountRequest) {
	request = &DescribeImageScanAuthCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeImageScanAuthCount", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImageScanAuthCountResponse creates a response to parse from DescribeImageScanAuthCount response
func CreateDescribeImageScanAuthCountResponse() (response *DescribeImageScanAuthCountResponse) {
	response = &DescribeImageScanAuthCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
