package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDomainHttpCodeData invokes the scdn.DescribeScdnDomainHttpCodeData API synchronously
func (client *Client) DescribeScdnDomainHttpCodeData(request *DescribeScdnDomainHttpCodeDataRequest) (response *DescribeScdnDomainHttpCodeDataResponse, err error) {
	response = CreateDescribeScdnDomainHttpCodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDomainHttpCodeDataWithChan invokes the scdn.DescribeScdnDomainHttpCodeData API asynchronously
func (client *Client) DescribeScdnDomainHttpCodeDataWithChan(request *DescribeScdnDomainHttpCodeDataRequest) (<-chan *DescribeScdnDomainHttpCodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDomainHttpCodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDomainHttpCodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDomainHttpCodeDataWithCallback invokes the scdn.DescribeScdnDomainHttpCodeData API asynchronously
func (client *Client) DescribeScdnDomainHttpCodeDataWithCallback(request *DescribeScdnDomainHttpCodeDataRequest, callback func(response *DescribeScdnDomainHttpCodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDomainHttpCodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDomainHttpCodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDomainHttpCodeDataRequest is the request struct for api DescribeScdnDomainHttpCodeData
type DescribeScdnDomainHttpCodeDataRequest struct {
	*requests.RpcRequest
	DomainName     string `position:"Query" name:"DomainName"`
	EndTime        string `position:"Query" name:"EndTime"`
	Interval       string `position:"Query" name:"Interval"`
	LocationNameEn string `position:"Query" name:"LocationNameEn"`
	StartTime      string `position:"Query" name:"StartTime"`
	IspNameEn      string `position:"Query" name:"IspNameEn"`
}

// DescribeScdnDomainHttpCodeDataResponse is the response struct for api DescribeScdnDomainHttpCodeData
type DescribeScdnDomainHttpCodeDataResponse struct {
	*responses.BaseResponse
	EndTime         string          `json:"EndTime" xml:"EndTime"`
	StartTime       string          `json:"StartTime" xml:"StartTime"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	DomainName      string          `json:"DomainName" xml:"DomainName"`
	DataInterval    string          `json:"DataInterval" xml:"DataInterval"`
	DataPerInterval DataPerInterval `json:"DataPerInterval" xml:"DataPerInterval"`
}

// CreateDescribeScdnDomainHttpCodeDataRequest creates a request to invoke DescribeScdnDomainHttpCodeData API
func CreateDescribeScdnDomainHttpCodeDataRequest() (request *DescribeScdnDomainHttpCodeDataRequest) {
	request = &DescribeScdnDomainHttpCodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDomainHttpCodeData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScdnDomainHttpCodeDataResponse creates a response to parse from DescribeScdnDomainHttpCodeData response
func CreateDescribeScdnDomainHttpCodeDataResponse() (response *DescribeScdnDomainHttpCodeDataResponse) {
	response = &DescribeScdnDomainHttpCodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
