package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportCalendar invokes the schedulerx3.ImportCalendar API synchronously
func (client *Client) ImportCalendar(request *ImportCalendarRequest) (response *ImportCalendarResponse, err error) {
	response = CreateImportCalendarResponse()
	err = client.DoAction(request, response)
	return
}

// ImportCalendarWithChan invokes the schedulerx3.ImportCalendar API asynchronously
func (client *Client) ImportCalendarWithChan(request *ImportCalendarRequest) (<-chan *ImportCalendarResponse, <-chan error) {
	responseChan := make(chan *ImportCalendarResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportCalendar(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportCalendarWithCallback invokes the schedulerx3.ImportCalendar API asynchronously
func (client *Client) ImportCalendarWithCallback(request *ImportCalendarRequest, callback func(response *ImportCalendarResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportCalendarResponse
		var err error
		defer close(result)
		response, err = client.ImportCalendar(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportCalendarRequest is the request struct for api ImportCalendar
type ImportCalendarRequest struct {
	*requests.RpcRequest
	MseSessionId string           `position:"Query" name:"MseSessionId"`
	Year         requests.Integer `position:"Body" name:"Year"`
	Months       string           `position:"Body" name:"Months"`
	ClusterId    string           `position:"Body" name:"ClusterId"`
	Name         string           `position:"Body" name:"Name"`
}

// ImportCalendarResponse is the response struct for api ImportCalendar
type ImportCalendarResponse struct {
	*responses.BaseResponse
	Code      int      `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateImportCalendarRequest creates a request to invoke ImportCalendar API
func CreateImportCalendarRequest() (request *ImportCalendarRequest) {
	request = &ImportCalendarRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ImportCalendar", "", "")
	request.Method = requests.POST
	return
}

// CreateImportCalendarResponse creates a response to parse from ImportCalendar response
func CreateImportCalendarResponse() (response *ImportCalendarResponse) {
	response = &ImportCalendarResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
