package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHighDefinationMonitor invokes the slb.ModifyHighDefinationMonitor API synchronously
func (client *Client) ModifyHighDefinationMonitor(request *ModifyHighDefinationMonitorRequest) (response *ModifyHighDefinationMonitorResponse, err error) {
	response = CreateModifyHighDefinationMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHighDefinationMonitorWithChan invokes the slb.ModifyHighDefinationMonitor API asynchronously
func (client *Client) ModifyHighDefinationMonitorWithChan(request *ModifyHighDefinationMonitorRequest) (<-chan *ModifyHighDefinationMonitorResponse, <-chan error) {
	responseChan := make(chan *ModifyHighDefinationMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHighDefinationMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHighDefinationMonitorWithCallback invokes the slb.ModifyHighDefinationMonitor API asynchronously
func (client *Client) ModifyHighDefinationMonitorWithCallback(request *ModifyHighDefinationMonitorRequest, callback func(response *ModifyHighDefinationMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHighDefinationMonitorResponse
		var err error
		defer close(result)
		response, err = client.ModifyHighDefinationMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHighDefinationMonitorRequest is the request struct for api ModifyHighDefinationMonitor
type ModifyHighDefinationMonitorRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LogProject           string           `position:"Query" name:"LogProject"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	LogStore             string           `position:"Query" name:"LogStore"`
}

// ModifyHighDefinationMonitorResponse is the response struct for api ModifyHighDefinationMonitor
type ModifyHighDefinationMonitorResponse struct {
	*responses.BaseResponse
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyHighDefinationMonitorRequest creates a request to invoke ModifyHighDefinationMonitor API
func CreateModifyHighDefinationMonitorRequest() (request *ModifyHighDefinationMonitorRequest) {
	request = &ModifyHighDefinationMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "ModifyHighDefinationMonitor", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyHighDefinationMonitorResponse creates a response to parse from ModifyHighDefinationMonitor response
func CreateModifyHighDefinationMonitorResponse() (response *ModifyHighDefinationMonitorResponse) {
	response = &ModifyHighDefinationMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
