package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetAccessLogsDownloadAttribute invokes the slb.SetAccessLogsDownloadAttribute API synchronously
func (client *Client) SetAccessLogsDownloadAttribute(request *SetAccessLogsDownloadAttributeRequest) (response *SetAccessLogsDownloadAttributeResponse, err error) {
	response = CreateSetAccessLogsDownloadAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// SetAccessLogsDownloadAttributeWithChan invokes the slb.SetAccessLogsDownloadAttribute API asynchronously
func (client *Client) SetAccessLogsDownloadAttributeWithChan(request *SetAccessLogsDownloadAttributeRequest) (<-chan *SetAccessLogsDownloadAttributeResponse, <-chan error) {
	responseChan := make(chan *SetAccessLogsDownloadAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetAccessLogsDownloadAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetAccessLogsDownloadAttributeWithCallback invokes the slb.SetAccessLogsDownloadAttribute API asynchronously
func (client *Client) SetAccessLogsDownloadAttributeWithCallback(request *SetAccessLogsDownloadAttributeRequest, callback func(response *SetAccessLogsDownloadAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetAccessLogsDownloadAttributeResponse
		var err error
		defer close(result)
		response, err = client.SetAccessLogsDownloadAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetAccessLogsDownloadAttributeRequest is the request struct for api SetAccessLogsDownloadAttribute
type SetAccessLogsDownloadAttributeRequest struct {
	*requests.RpcRequest
	AccessKeyId            string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LogsDownloadAttributes string           `position:"Query" name:"LogsDownloadAttributes"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	Tags                   string           `position:"Query" name:"Tags"`
	LoadBalancerId         string           `position:"Query" name:"LoadBalancerId"`
}

// SetAccessLogsDownloadAttributeResponse is the response struct for api SetAccessLogsDownloadAttribute
type SetAccessLogsDownloadAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetAccessLogsDownloadAttributeRequest creates a request to invoke SetAccessLogsDownloadAttribute API
func CreateSetAccessLogsDownloadAttributeRequest() (request *SetAccessLogsDownloadAttributeRequest) {
	request = &SetAccessLogsDownloadAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "SetAccessLogsDownloadAttribute", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetAccessLogsDownloadAttributeResponse creates a response to parse from SetAccessLogsDownloadAttribute response
func CreateSetAccessLogsDownloadAttributeResponse() (response *SetAccessLogsDownloadAttributeResponse) {
	response = &SetAccessLogsDownloadAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
