package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlaybooks invokes the sophonsoar.DescribePlaybooks API synchronously
func (client *Client) DescribePlaybooks(request *DescribePlaybooksRequest) (response *DescribePlaybooksResponse, err error) {
	response = CreateDescribePlaybooksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlaybooksWithChan invokes the sophonsoar.DescribePlaybooks API asynchronously
func (client *Client) DescribePlaybooksWithChan(request *DescribePlaybooksRequest) (<-chan *DescribePlaybooksResponse, <-chan error) {
	responseChan := make(chan *DescribePlaybooksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlaybooks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlaybooksWithCallback invokes the sophonsoar.DescribePlaybooks API asynchronously
func (client *Client) DescribePlaybooksWithCallback(request *DescribePlaybooksRequest, callback func(response *DescribePlaybooksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlaybooksResponse
		var err error
		defer close(result)
		response, err = client.DescribePlaybooks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlaybooksRequest is the request struct for api DescribePlaybooks
type DescribePlaybooksRequest struct {
	*requests.RpcRequest
	RoleFor       string           `position:"Query" name:"RoleFor"`
	EndMillis     requests.Integer `position:"Query" name:"EndMillis"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	PlaybookUuids string           `position:"Query" name:"PlaybookUuids"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	RoleType      string           `position:"Query" name:"RoleType"`
	Lang          string           `position:"Query" name:"Lang"`
	Order         string           `position:"Query" name:"Order"`
	ParamTypes    string           `position:"Query" name:"ParamTypes"`
	Active        requests.Integer `position:"Query" name:"Active"`
	OwnType       string           `position:"Query" name:"OwnType"`
	Sort          string           `position:"Query" name:"Sort"`
	StartMillis   requests.Integer `position:"Query" name:"StartMillis"`
	PlaybookUuid  string           `position:"Query" name:"PlaybookUuid"`
	Name          string           `position:"Query" name:"Name"`
}

// DescribePlaybooksResponse is the response struct for api DescribePlaybooks
type DescribePlaybooksResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Page      Page                      `json:"Page" xml:"Page"`
	Playbooks []DataInDescribePlaybooks `json:"Playbooks" xml:"Playbooks"`
}

// CreateDescribePlaybooksRequest creates a request to invoke DescribePlaybooks API
func CreateDescribePlaybooksRequest() (request *DescribePlaybooksRequest) {
	request = &DescribePlaybooksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePlaybooks", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePlaybooksResponse creates a response to parse from DescribePlaybooks response
func CreateDescribePlaybooksResponse() (response *DescribePlaybooksResponse) {
	response = &DescribePlaybooksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
