package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSoarRecordInOutput invokes the sophonsoar.DescribeSoarRecordInOutput API synchronously
func (client *Client) DescribeSoarRecordInOutput(request *DescribeSoarRecordInOutputRequest) (response *DescribeSoarRecordInOutputResponse, err error) {
	response = CreateDescribeSoarRecordInOutputResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSoarRecordInOutputWithChan invokes the sophonsoar.DescribeSoarRecordInOutput API asynchronously
func (client *Client) DescribeSoarRecordInOutputWithChan(request *DescribeSoarRecordInOutputRequest) (<-chan *DescribeSoarRecordInOutputResponse, <-chan error) {
	responseChan := make(chan *DescribeSoarRecordInOutputResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSoarRecordInOutput(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSoarRecordInOutputWithCallback invokes the sophonsoar.DescribeSoarRecordInOutput API asynchronously
func (client *Client) DescribeSoarRecordInOutputWithCallback(request *DescribeSoarRecordInOutputRequest, callback func(response *DescribeSoarRecordInOutputResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSoarRecordInOutputResponse
		var err error
		defer close(result)
		response, err = client.DescribeSoarRecordInOutput(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSoarRecordInOutputRequest is the request struct for api DescribeSoarRecordInOutput
type DescribeSoarRecordInOutputRequest struct {
	*requests.RpcRequest
	ActionUuid string `position:"Query" name:"ActionUuid"`
	RoleFor    string `position:"Query" name:"RoleFor"`
	RoleType   string `position:"Query" name:"RoleType"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeSoarRecordInOutputResponse is the response struct for api DescribeSoarRecordInOutput
type DescribeSoarRecordInOutputResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	InOutputInfo string `json:"InOutputInfo" xml:"InOutputInfo"`
}

// CreateDescribeSoarRecordInOutputRequest creates a request to invoke DescribeSoarRecordInOutput API
func CreateDescribeSoarRecordInOutputRequest() (request *DescribeSoarRecordInOutputRequest) {
	request = &DescribeSoarRecordInOutputRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeSoarRecordInOutput", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeSoarRecordInOutputResponse creates a response to parse from DescribeSoarRecordInOutput response
func CreateDescribeSoarRecordInOutputResponse() (response *DescribeSoarRecordInOutputResponse) {
	response = &DescribeSoarRecordInOutputResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
