package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatabaseInstanceMetricData invokes the swas_open.DescribeDatabaseInstanceMetricData API synchronously
func (client *Client) DescribeDatabaseInstanceMetricData(request *DescribeDatabaseInstanceMetricDataRequest) (response *DescribeDatabaseInstanceMetricDataResponse, err error) {
	response = CreateDescribeDatabaseInstanceMetricDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatabaseInstanceMetricDataWithChan invokes the swas_open.DescribeDatabaseInstanceMetricData API asynchronously
func (client *Client) DescribeDatabaseInstanceMetricDataWithChan(request *DescribeDatabaseInstanceMetricDataRequest) (<-chan *DescribeDatabaseInstanceMetricDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDatabaseInstanceMetricDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatabaseInstanceMetricData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatabaseInstanceMetricDataWithCallback invokes the swas_open.DescribeDatabaseInstanceMetricData API asynchronously
func (client *Client) DescribeDatabaseInstanceMetricDataWithCallback(request *DescribeDatabaseInstanceMetricDataRequest, callback func(response *DescribeDatabaseInstanceMetricDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatabaseInstanceMetricDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatabaseInstanceMetricData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatabaseInstanceMetricDataRequest is the request struct for api DescribeDatabaseInstanceMetricData
type DescribeDatabaseInstanceMetricDataRequest struct {
	*requests.RpcRequest
	DatabaseInstanceId string `position:"Query" name:"DatabaseInstanceId"`
	EndTime            string `position:"Query" name:"EndTime"`
	StartTime          string `position:"Query" name:"StartTime"`
	MetricName         string `position:"Query" name:"MetricName"`
}

// DescribeDatabaseInstanceMetricDataResponse is the response struct for api DescribeDatabaseInstanceMetricData
type DescribeDatabaseInstanceMetricDataResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	MetricName string `json:"MetricName" xml:"MetricName"`
	Unit       string `json:"Unit" xml:"Unit"`
	DataFormat string `json:"DataFormat" xml:"DataFormat"`
	MetricData string `json:"MetricData" xml:"MetricData"`
}

// CreateDescribeDatabaseInstanceMetricDataRequest creates a request to invoke DescribeDatabaseInstanceMetricData API
func CreateDescribeDatabaseInstanceMetricDataRequest() (request *DescribeDatabaseInstanceMetricDataRequest) {
	request = &DescribeDatabaseInstanceMetricDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeDatabaseInstanceMetricData", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDatabaseInstanceMetricDataResponse creates a response to parse from DescribeDatabaseInstanceMetricData response
func CreateDescribeDatabaseInstanceMetricDataResponse() (response *DescribeDatabaseInstanceMetricDataResponse) {
	response = &DescribeDatabaseInstanceMetricDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
