package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSavepoints invokes the ververica.ListSavepoints API synchronously
func (client *Client) ListSavepoints(request *ListSavepointsRequest) (response *ListSavepointsResponse, err error) {
	response = CreateListSavepointsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSavepointsWithChan invokes the ververica.ListSavepoints API asynchronously
func (client *Client) ListSavepointsWithChan(request *ListSavepointsRequest) (<-chan *ListSavepointsResponse, <-chan error) {
	responseChan := make(chan *ListSavepointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSavepoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSavepointsWithCallback invokes the ververica.ListSavepoints API asynchronously
func (client *Client) ListSavepointsWithCallback(request *ListSavepointsRequest, callback func(response *ListSavepointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSavepointsResponse
		var err error
		defer close(result)
		response, err = client.ListSavepoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSavepointsRequest is the request struct for api ListSavepoints
type ListSavepointsRequest struct {
	*requests.RoaRequest
	JobId        string `position:"Query" name:"jobId"`
	Workspace    string `position:"Path" name:"workspace"`
	DeploymentId string `position:"Query" name:"deploymentId"`
	Namespace    string `position:"Path" name:"namespace"`
}

// ListSavepointsResponse is the response struct for api ListSavepoints
type ListSavepointsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListSavepointsRequest creates a request to invoke ListSavepoints API
func CreateListSavepointsRequest() (request *ListSavepointsRequest) {
	request = &ListSavepointsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListSavepoints", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/savepoints", "", "")
	request.Method = requests.GET
	return
}

// CreateListSavepointsResponse creates a response to parse from ListSavepoints response
func CreateListSavepointsResponse() (response *ListSavepointsResponse) {
	response = &ListSavepointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
