package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ValidateSqlScript invokes the ververica.ValidateSqlScript API synchronously
func (client *Client) ValidateSqlScript(request *ValidateSqlScriptRequest) (response *ValidateSqlScriptResponse, err error) {
	response = CreateValidateSqlScriptResponse()
	err = client.DoAction(request, response)
	return
}

// ValidateSqlScriptWithChan invokes the ververica.ValidateSqlScript API asynchronously
func (client *Client) ValidateSqlScriptWithChan(request *ValidateSqlScriptRequest) (<-chan *ValidateSqlScriptResponse, <-chan error) {
	responseChan := make(chan *ValidateSqlScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ValidateSqlScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ValidateSqlScriptWithCallback invokes the ververica.ValidateSqlScript API asynchronously
func (client *Client) ValidateSqlScriptWithCallback(request *ValidateSqlScriptRequest, callback func(response *ValidateSqlScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ValidateSqlScriptResponse
		var err error
		defer close(result)
		response, err = client.ValidateSqlScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ValidateSqlScriptRequest is the request struct for api ValidateSqlScript
type ValidateSqlScriptRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// ValidateSqlScriptResponse is the response struct for api ValidateSqlScript
type ValidateSqlScriptResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateValidateSqlScriptRequest creates a request to invoke ValidateSqlScript API
func CreateValidateSqlScriptRequest() (request *ValidateSqlScriptRequest) {
	request = &ValidateSqlScriptRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ValidateSqlScript", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/sqlscripts:validate", "", "")
	request.Method = requests.POST
	return
}

// CreateValidateSqlScriptResponse creates a response to parse from ValidateSqlScript response
func CreateValidateSqlScriptResponse() (response *ValidateSqlScriptResponse) {
	response = &ValidateSqlScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
