package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRecording invokes the voicenavigator.DescribeRecording API synchronously
func (client *Client) DescribeRecording(request *DescribeRecordingRequest) (response *DescribeRecordingResponse, err error) {
	response = CreateDescribeRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRecordingWithChan invokes the voicenavigator.DescribeRecording API asynchronously
func (client *Client) DescribeRecordingWithChan(request *DescribeRecordingRequest) (<-chan *DescribeRecordingResponse, <-chan error) {
	responseChan := make(chan *DescribeRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRecordingWithCallback invokes the voicenavigator.DescribeRecording API asynchronously
func (client *Client) DescribeRecordingWithCallback(request *DescribeRecordingRequest, callback func(response *DescribeRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRecordingResponse
		var err error
		defer close(result)
		response, err = client.DescribeRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRecordingRequest is the request struct for api DescribeRecording
type DescribeRecordingRequest struct {
	*requests.RpcRequest
	NeedVoiceSliceRecording requests.Boolean `position:"Query" name:"NeedVoiceSliceRecording"`
	ConversationId          string           `position:"Query" name:"ConversationId"`
	InstanceId              string           `position:"Query" name:"InstanceId"`
}

// DescribeRecordingResponse is the response struct for api DescribeRecording
type DescribeRecordingResponse struct {
	*responses.BaseResponse
	FilePath                    string `json:"FilePath" xml:"FilePath"`
	RequestId                   string `json:"RequestId" xml:"RequestId"`
	FileName                    string `json:"FileName" xml:"FileName"`
	VoiceSliceRecordingListJson string `json:"VoiceSliceRecordingListJson" xml:"VoiceSliceRecordingListJson"`
}

// CreateDescribeRecordingRequest creates a request to invoke DescribeRecording API
func CreateDescribeRecordingRequest() (request *DescribeRecordingRequest) {
	request = &DescribeRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DescribeRecording", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeRecordingResponse creates a response to parse from DescribeRecording response
func CreateDescribeRecordingResponse() (response *DescribeRecordingResponse) {
	response = &DescribeRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
