package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsDomainPvData invokes the vs.DescribeVsDomainPvData API synchronously
func (client *Client) DescribeVsDomainPvData(request *DescribeVsDomainPvDataRequest) (response *DescribeVsDomainPvDataResponse, err error) {
	response = CreateDescribeVsDomainPvDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsDomainPvDataWithChan invokes the vs.DescribeVsDomainPvData API asynchronously
func (client *Client) DescribeVsDomainPvDataWithChan(request *DescribeVsDomainPvDataRequest) (<-chan *DescribeVsDomainPvDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsDomainPvDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsDomainPvData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsDomainPvDataWithCallback invokes the vs.DescribeVsDomainPvData API asynchronously
func (client *Client) DescribeVsDomainPvDataWithCallback(request *DescribeVsDomainPvDataRequest, callback func(response *DescribeVsDomainPvDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsDomainPvDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsDomainPvData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsDomainPvDataRequest is the request struct for api DescribeVsDomainPvData
type DescribeVsDomainPvDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	ShowLog    string           `position:"Query" name:"ShowLog"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsDomainPvDataResponse is the response struct for api DescribeVsDomainPvData
type DescribeVsDomainPvDataResponse struct {
	*responses.BaseResponse
	EndTime        string         `json:"EndTime" xml:"EndTime"`
	StartTime      string         `json:"StartTime" xml:"StartTime"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	DomainName     string         `json:"DomainName" xml:"DomainName"`
	DataInterval   string         `json:"DataInterval" xml:"DataInterval"`
	PvDataInterval PvDataInterval `json:"PvDataInterval" xml:"PvDataInterval"`
}

// CreateDescribeVsDomainPvDataRequest creates a request to invoke DescribeVsDomainPvData API
func CreateDescribeVsDomainPvDataRequest() (request *DescribeVsDomainPvDataRequest) {
	request = &DescribeVsDomainPvDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsDomainPvData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsDomainPvDataResponse creates a response to parse from DescribeVsDomainPvData response
func CreateDescribeVsDomainPvDataResponse() (response *DescribeVsDomainPvDataResponse) {
	response = &DescribeVsDomainPvDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
