package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartStream invokes the vs.StartStream API synchronously
func (client *Client) StartStream(request *StartStreamRequest) (response *StartStreamResponse, err error) {
	response = CreateStartStreamResponse()
	err = client.DoAction(request, response)
	return
}

// StartStreamWithChan invokes the vs.StartStream API asynchronously
func (client *Client) StartStreamWithChan(request *StartStreamRequest) (<-chan *StartStreamResponse, <-chan error) {
	responseChan := make(chan *StartStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartStreamWithCallback invokes the vs.StartStream API asynchronously
func (client *Client) StartStreamWithCallback(request *StartStreamRequest, callback func(response *StartStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartStreamResponse
		var err error
		defer close(result)
		response, err = client.StartStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartStreamRequest is the request struct for api StartStream
type StartStreamRequest struct {
	*requests.RpcRequest
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	Id        string           `position:"Query" name:"Id"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// StartStreamResponse is the response struct for api StartStream
type StartStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Name      string `json:"Name" xml:"Name"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateStartStreamRequest creates a request to invoke StartStream API
func CreateStartStreamRequest() (request *StartStreamRequest) {
	request = &StartStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "StartStream", "", "")
	request.Method = requests.POST
	return
}

// CreateStartStreamResponse creates a response to parse from StartStream response
func CreateStartStreamResponse() (response *StartStreamResponse) {
	response = &StartStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
