package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MaoefeTs invokes the amp.MaoefeTs API synchronously
func (client *Client) MaoefeTs(request *MaoefeTsRequest) (response *MaoefeTsResponse, err error) {
	response = CreateMaoefeTsResponse()
	err = client.DoAction(request, response)
	return
}

// MaoefeTsWithChan invokes the amp.MaoefeTs API asynchronously
func (client *Client) MaoefeTsWithChan(request *MaoefeTsRequest) (<-chan *MaoefeTsResponse, <-chan error) {
	responseChan := make(chan *MaoefeTsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MaoefeTs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MaoefeTsWithCallback invokes the amp.MaoefeTs API asynchronously
func (client *Client) MaoefeTsWithCallback(request *MaoefeTsRequest, callback func(response *MaoefeTsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MaoefeTsResponse
		var err error
		defer close(result)
		response, err = client.MaoefeTs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MaoefeTsRequest is the request struct for api MaoefeTs
type MaoefeTsRequest struct {
	*requests.RoaRequest
}

// MaoefeTsResponse is the response struct for api MaoefeTs
type MaoefeTsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateMaoefeTsRequest creates a request to invoke MaoefeTs API
func CreateMaoefeTsRequest() (request *MaoefeTsRequest) {
	request = &MaoefeTsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "MaoefeTs", "/eo/efe", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMaoefeTsResponse creates a response to parse from MaoefeTs response
func CreateMaoefeTsResponse() (response *MaoefeTsResponse) {
	response = &MaoefeTsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
