package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPrometheusRemoteWrite invokes the arms.AddPrometheusRemoteWrite API synchronously
func (client *Client) AddPrometheusRemoteWrite(request *AddPrometheusRemoteWriteRequest) (response *AddPrometheusRemoteWriteResponse, err error) {
	response = CreateAddPrometheusRemoteWriteResponse()
	err = client.DoAction(request, response)
	return
}

// AddPrometheusRemoteWriteWithChan invokes the arms.AddPrometheusRemoteWrite API asynchronously
func (client *Client) AddPrometheusRemoteWriteWithChan(request *AddPrometheusRemoteWriteRequest) (<-chan *AddPrometheusRemoteWriteResponse, <-chan error) {
	responseChan := make(chan *AddPrometheusRemoteWriteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPrometheusRemoteWrite(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPrometheusRemoteWriteWithCallback invokes the arms.AddPrometheusRemoteWrite API asynchronously
func (client *Client) AddPrometheusRemoteWriteWithCallback(request *AddPrometheusRemoteWriteRequest, callback func(response *AddPrometheusRemoteWriteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPrometheusRemoteWriteResponse
		var err error
		defer close(result)
		response, err = client.AddPrometheusRemoteWrite(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPrometheusRemoteWriteRequest is the request struct for api AddPrometheusRemoteWrite
type AddPrometheusRemoteWriteRequest struct {
	*requests.RpcRequest
	ClusterId       string `position:"Query" name:"ClusterId"`
	RemoteWriteYaml string `position:"Body" name:"RemoteWriteYaml"`
}

// AddPrometheusRemoteWriteResponse is the response struct for api AddPrometheusRemoteWrite
type AddPrometheusRemoteWriteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateAddPrometheusRemoteWriteRequest creates a request to invoke AddPrometheusRemoteWrite API
func CreateAddPrometheusRemoteWriteRequest() (request *AddPrometheusRemoteWriteRequest) {
	request = &AddPrometheusRemoteWriteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "AddPrometheusRemoteWrite", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPrometheusRemoteWriteResponse creates a response to parse from AddPrometheusRemoteWrite response
func CreateAddPrometheusRemoteWriteResponse() (response *AddPrometheusRemoteWriteResponse) {
	response = &AddPrometheusRemoteWriteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
