package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseTimedResetOperate invokes the avatar.CloseTimedResetOperate API synchronously
func (client *Client) CloseTimedResetOperate(request *CloseTimedResetOperateRequest) (response *CloseTimedResetOperateResponse, err error) {
	response = CreateCloseTimedResetOperateResponse()
	err = client.DoAction(request, response)
	return
}

// CloseTimedResetOperateWithChan invokes the avatar.CloseTimedResetOperate API asynchronously
func (client *Client) CloseTimedResetOperateWithChan(request *CloseTimedResetOperateRequest) (<-chan *CloseTimedResetOperateResponse, <-chan error) {
	responseChan := make(chan *CloseTimedResetOperateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseTimedResetOperate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseTimedResetOperateWithCallback invokes the avatar.CloseTimedResetOperate API asynchronously
func (client *Client) CloseTimedResetOperateWithCallback(request *CloseTimedResetOperateRequest, callback func(response *CloseTimedResetOperateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseTimedResetOperateResponse
		var err error
		defer close(result)
		response, err = client.CloseTimedResetOperate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseTimedResetOperateRequest is the request struct for api CloseTimedResetOperate
type CloseTimedResetOperateRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	TenantId   requests.Integer `position:"Query" name:"TenantId"`
}

// CloseTimedResetOperateResponse is the response struct for api CloseTimedResetOperate
type CloseTimedResetOperateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCloseTimedResetOperateRequest creates a request to invoke CloseTimedResetOperate API
func CreateCloseTimedResetOperateRequest() (request *CloseTimedResetOperateRequest) {
	request = &CloseTimedResetOperateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "CloseTimedResetOperate", "", "")
	request.Method = requests.POST
	return
}

// CreateCloseTimedResetOperateResponse creates a response to parse from CloseTimedResetOperate response
func CreateCloseTimedResetOperateResponse() (response *CloseTimedResetOperateResponse) {
	response = &CloseTimedResetOperateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
