package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartTimedResetOperate invokes the avatar.StartTimedResetOperate API synchronously
func (client *Client) StartTimedResetOperate(request *StartTimedResetOperateRequest) (response *StartTimedResetOperateResponse, err error) {
	response = CreateStartTimedResetOperateResponse()
	err = client.DoAction(request, response)
	return
}

// StartTimedResetOperateWithChan invokes the avatar.StartTimedResetOperate API asynchronously
func (client *Client) StartTimedResetOperateWithChan(request *StartTimedResetOperateRequest) (<-chan *StartTimedResetOperateResponse, <-chan error) {
	responseChan := make(chan *StartTimedResetOperateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartTimedResetOperate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartTimedResetOperateWithCallback invokes the avatar.StartTimedResetOperate API asynchronously
func (client *Client) StartTimedResetOperateWithCallback(request *StartTimedResetOperateRequest, callback func(response *StartTimedResetOperateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartTimedResetOperateResponse
		var err error
		defer close(result)
		response, err = client.StartTimedResetOperate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartTimedResetOperateRequest is the request struct for api StartTimedResetOperate
type StartTimedResetOperateRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	TenantId   requests.Integer `position:"Query" name:"TenantId"`
}

// StartTimedResetOperateResponse is the response struct for api StartTimedResetOperate
type StartTimedResetOperateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateStartTimedResetOperateRequest creates a request to invoke StartTimedResetOperate API
func CreateStartTimedResetOperateRequest() (request *StartTimedResetOperateRequest) {
	request = &StartTimedResetOperateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "StartTimedResetOperate", "", "")
	request.Method = requests.POST
	return
}

// CreateStartTimedResetOperateResponse creates a response to parse from StartTimedResetOperate response
func CreateStartTimedResetOperateResponse() (response *StartTimedResetOperateResponse) {
	response = &StartTimedResetOperateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
