package btripopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AccessToken invokes the btripopen.AccessToken API synchronously
func (client *Client) AccessToken(request *AccessTokenRequest) (response *AccessTokenResponse, err error) {
	response = CreateAccessTokenResponse()
	err = client.DoAction(request, response)
	return
}

// AccessTokenWithChan invokes the btripopen.AccessToken API asynchronously
func (client *Client) AccessTokenWithChan(request *AccessTokenRequest) (<-chan *AccessTokenResponse, <-chan error) {
	responseChan := make(chan *AccessTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AccessToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AccessTokenWithCallback invokes the btripopen.AccessToken API asynchronously
func (client *Client) AccessTokenWithCallback(request *AccessTokenRequest, callback func(response *AccessTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AccessTokenResponse
		var err error
		defer close(result)
		response, err = client.AccessToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AccessTokenRequest is the request struct for api AccessToken
type AccessTokenRequest struct {
	*requests.RoaRequest
	AppKey    string `position:"Query" name:"app_key"`
	AppSecret string `position:"Query" name:"app_secret"`
}

// AccessTokenResponse is the response struct for api AccessToken
type AccessTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	TraceId   string `json:"traceId" xml:"traceId"`
	Message   string `json:"message" xml:"message"`
	Code      string `json:"code" xml:"code"`
	Data      Data   `json:"data" xml:"data"`
}

// CreateAccessTokenRequest creates a request to invoke AccessToken API
func CreateAccessTokenRequest() (request *AccessTokenRequest) {
	request = &AccessTokenRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("btripOpen", "2022-05-20", "AccessToken", "/btrip-open-auth/v1/access-token/action/take", "", "")
	request.Method = requests.GET
	return
}

// CreateAccessTokenResponse creates a response to parse from AccessToken response
func CreateAccessTokenResponse() (response *AccessTokenResponse) {
	response = &AccessTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
